/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.AbstractCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import java.sql.SQLException;
import java.util.concurrent.Flow;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OracleTransactionCommand<R>
extends AbstractCommand<R> {
    private final TxCommand<R> op;

    public OracleTransactionCommand(TxCommand<R> op) {
        this.op = op;
    }

    @Override
    public Future<R> execute(OracleConnection conn, ContextInternal context) {
        if (this.op.kind == TxCommand.Kind.BEGIN) {
            return this.begin(conn, context).map(x -> this.op.result);
        }
        if (this.op.kind == TxCommand.Kind.COMMIT) {
            return this.commit(conn, context).map(x -> this.op.result).onComplete(x -> Helper.runOrHandleSQLException(() -> conn.setAutoCommit(false)));
        }
        return this.rollback(conn, context).map(x -> this.op.result).onComplete(x -> Helper.runOrHandleSQLException(() -> conn.setAutoCommit(false)));
    }

    private Future<Void> begin(OracleConnection conn, ContextInternal context) {
        String isolationLevel;
        int isolation = Helper.getOrHandleSQLException(() -> conn.getTransactionIsolation());
        switch (isolation) {
            case 2: {
                isolationLevel = "READ COMMITTED";
                break;
            }
            case 8: {
                isolationLevel = "SERIALIZABLE";
                break;
            }
            default: {
                throw new IllegalArgumentException("Invalid isolation level: " + isolation);
            }
        }
        try {
            conn.setAutoCommit(false);
            Flow.Publisher publisher = conn.prepareStatement("SET TRANSACTION ISOLATION LEVEL " + isolationLevel).unwrap(OraclePreparedStatement.class).executeAsyncOracle();
            return Helper.first(publisher, context).map(x -> null);
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
    }

    private Future<Void> commit(OracleConnection conn, ContextInternal context) {
        try {
            if (conn.getAutoCommit()) {
                return context.succeededFuture();
            }
            return Helper.first(conn.commitAsyncOracle(), context);
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
    }

    private Future<Void> rollback(OracleConnection conn, ContextInternal context) {
        try {
            if (conn.getAutoCommit()) {
                return context.succeededFuture();
            }
            return Helper.first(conn.rollbackAsyncOracle(), context);
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
    }
}

