/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.SocketAddress;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleMetadataImpl;
import io.vertx.oracleclient.impl.commands.OracleCursorQueryCommand;
import io.vertx.oracleclient.impl.commands.OraclePreparedBatch;
import io.vertx.oracleclient.impl.commands.OraclePreparedQuery;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.OracleTransactionCommand;
import io.vertx.oracleclient.impl.commands.PingCommand;
import io.vertx.oracleclient.impl.commands.PrepareStatementCommand;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.oracleclient.impl.commands.SimpleQueryCommand;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import io.vertx.sqlclient.impl.command.TxCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.sql.SQLException;
import oracle.jdbc.OracleConnection;

public class CommandHandler
implements Connection {
    private final OracleConnection connection;
    private final ContextInternal context;
    private final OracleConnectOptions options;
    private Connection.Holder holder;

    public CommandHandler(ContextInternal ctx, OracleConnectOptions options, OracleConnection oc) {
        this.context = ctx;
        this.options = options;
        this.connection = oc;
    }

    public SocketAddress server() {
        throw new UnsupportedOperationException("Not yet implemented");
    }

    public void init(Connection.Holder holder) {
        this.holder = holder;
    }

    public boolean isSsl() {
        return this.options.isSsl();
    }

    public boolean isValid() {
        return true;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return new OracleMetadataImpl(Helper.getOrHandleSQLException(() -> this.connection.getMetaData()));
    }

    public void close(Connection.Holder holder, Promise<Void> promise) {
        Helper.executeBlocking((Context)this.context, () -> this.connection.closeAsyncOracle()).compose(publisher -> Helper.first(publisher, this.context)).onSuccess(v -> {
            holder.handleClosed();
            promise.complete();
        }).onFailure(t -> {
            holder.handleClosed();
            promise.fail(t);
        });
    }

    public int getProcessId() {
        throw new UnsupportedOperationException();
    }

    public int getSecretKey() {
        throw new UnsupportedOperationException();
    }

    public Future<Void> afterAcquire() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.executeBlocking(prom -> {
            try {
                this.connection.beginRequest();
                prom.complete();
            }
            catch (SQLException e) {
                prom.fail((Throwable)e);
            }
        }, false, (Handler)promise);
        return promise.future();
    }

    public Future<Void> beforeRecycle() {
        PromiseInternal promise = this.context.owner().promise();
        this.context.executeBlocking(prom -> {
            try {
                this.connection.endRequest();
                prom.complete();
            }
            catch (SQLException e) {
                prom.fail((Throwable)e);
            }
        }, false, (Handler)promise);
        return promise.future();
    }

    public <R> Future<R> schedule(ContextInternal contextInternal, CommandBase<R> commandBase) {
        Object result = commandBase instanceof io.vertx.sqlclient.impl.command.SimpleQueryCommand ? this.handle((io.vertx.sqlclient.impl.command.SimpleQueryCommand)commandBase) : (commandBase instanceof io.vertx.sqlclient.impl.command.PrepareStatementCommand ? this.handle((io.vertx.sqlclient.impl.command.PrepareStatementCommand)commandBase) : (commandBase instanceof ExtendedQueryCommand ? this.handle((ExtendedQueryCommand)commandBase) : (commandBase instanceof TxCommand ? this.handle((TxCommand)commandBase) : (commandBase instanceof PingCommand ? this.handle((PingCommand)commandBase) : this.context.failedFuture("Not yet implemented " + commandBase)))));
        return result.transform(ar -> {
            PromiseInternal promise = contextInternal.promise();
            if (ar.succeeded()) {
                promise.complete(ar.result());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof SQLException) {
                    SQLException sqlException = (SQLException)cause;
                    if (Helper.isFatal(sqlException)) {
                        Promise closePromise = Promise.promise();
                        this.close(this.holder, (Promise<Void>)closePromise);
                        closePromise.future().onComplete(arg_0 -> CommandHandler.lambda$schedule$6((Promise)promise, sqlException, arg_0));
                    } else {
                        promise.fail((Throwable)sqlException);
                    }
                } else {
                    promise.fail(cause);
                }
            }
            return promise.future();
        });
    }

    private Future<Integer> handle(PingCommand ping) {
        return ping.execute(this.connection, this.context);
    }

    private <R> Future<Boolean> handle(io.vertx.sqlclient.impl.command.SimpleQueryCommand command) {
        SimpleQueryCommand action = new SimpleQueryCommand(command.sql(), command.collector());
        return this.handle(action, command.resultHandler());
    }

    private Future<PreparedStatement> handle(io.vertx.sqlclient.impl.command.PrepareStatementCommand command) {
        PrepareStatementCommand action = new PrepareStatementCommand(OraclePrepareOptions.createFrom(command.options()), command.sql());
        return action.execute(this.connection, this.context);
    }

    private <R> Future<Boolean> handle(QueryCommand<?, R> action, QueryResultHandler<R> handler) {
        Future<OracleResponse<R>> fut = action.execute(this.connection, this.context);
        return fut.onSuccess(ar -> ar.handle(handler)).map((Object)false).onFailure(t -> this.holder.handleException(t));
    }

    private <R> Future<Boolean> handle(ExtendedQueryCommand<R> command) {
        if (command.cursorId() != null) {
            OracleCursorQueryCommand cmd = new OracleCursorQueryCommand(command, command.params());
            return cmd.execute(this.connection, this.context).map((Object)false);
        }
        QueryCommand action = command.isBatch() ? new OraclePreparedBatch(command, command.collector(), command.paramsList()) : new OraclePreparedQuery(command, command.collector(), command.params());
        return this.handle(action, command.resultHandler());
    }

    private <R> Future<R> handle(TxCommand<R> command) {
        OracleTransactionCommand<R> action = new OracleTransactionCommand<R>(command);
        return action.execute(this.connection, this.context);
    }

    private static /* synthetic */ void lambda$schedule$6(Promise promise, SQLException sqlException, AsyncResult v) {
        promise.fail((Throwable)sqlException);
    }
}

