/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.netty.util.collection.IntObjectHashMap;
import io.netty.util.collection.IntObjectMap;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import io.vertx.sqlclient.impl.RowDesc;
import java.sql.JDBCType;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Map;
import oracle.sql.TIMESTAMPTZ;

public class OracleColumnDesc
implements ColumnDescriptor {
    private static final IntObjectMap<JDBCType> TYPES_BY_VENDOR_TYPE_NUMBER = new IntObjectHashMap();
    private static final Map<String, JDBCType> TYPES_BY_CLASSNAME;
    private final String name;
    private final String typeName;
    private final JDBCType type;

    public static RowDesc rowDesc(ResultSetMetaData metaData) throws SQLException {
        int cols = metaData.getColumnCount();
        ArrayList<String> columnNames = new ArrayList<String>(cols);
        ArrayList<OracleColumnDesc> columnDescriptors = new ArrayList<OracleColumnDesc>(cols);
        for (int i = 1; i <= cols; ++i) {
            columnNames.add(metaData.getColumnLabel(i));
            columnDescriptors.add(new OracleColumnDesc(metaData, i));
        }
        return new RowDesc(columnNames, columnDescriptors);
    }

    public OracleColumnDesc(ResultSetMetaData md, int idx) throws SQLException {
        this.name = md.getColumnLabel(idx);
        this.typeName = md.getColumnTypeName(idx);
        this.type = this.find(md, idx);
    }

    private JDBCType find(ResultSetMetaData md, int idx) throws SQLException {
        JDBCType res = (JDBCType)TYPES_BY_VENDOR_TYPE_NUMBER.get(md.getColumnType(idx));
        if (res == null && (res = TYPES_BY_CLASSNAME.get(md.getColumnClassName(idx))) == null) {
            res = JDBCType.OTHER;
        }
        return res;
    }

    public String name() {
        return this.name;
    }

    public boolean isArray() {
        return this.type == JDBCType.ARRAY;
    }

    public String typeName() {
        return this.typeName;
    }

    public JDBCType jdbcType() {
        return this.type;
    }

    static {
        for (JDBCType type : JDBCType.values()) {
            TYPES_BY_VENDOR_TYPE_NUMBER.put((Object)type.getVendorTypeNumber(), (Object)type);
        }
        TYPES_BY_CLASSNAME = new HashMap<String, JDBCType>();
        TYPES_BY_CLASSNAME.put(TIMESTAMPTZ.class.getName(), JDBCType.TIMESTAMP_WITH_TIMEZONE);
    }
}

