/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.RowReader;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Flow;
import oracle.jdbc.OraclePreparedStatement;

public class OracleCursorQueryCommand<C, R>
extends QueryCommand<C, R> {
    private final ExtendedQueryCommand<R> command;
    private final Tuple params;

    public OracleCursorQueryCommand(ExtendedQueryCommand<R> command, Tuple params) {
        super(null);
        this.command = command;
        this.params = params;
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return OraclePrepareOptions.createFrom(this.command.options());
    }

    @Override
    protected String query() {
        return this.command.sql();
    }

    @Override
    protected void applyStatementOptions(Statement statement) throws SQLException {
        int fetch;
        String cursorId = this.command.cursorId();
        if (cursorId != null) {
            statement.setCursorName(cursorId);
        }
        if ((fetch = this.command.fetch()) > 0) {
            statement.setFetchSize(fetch);
        }
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    @Override
    protected Future<OracleResponse<R>> doExecute(OraclePreparedStatement ps, ContextInternal context, boolean returnAutoGeneratedKeys) {
        Flow.Publisher publisher;
        try {
            publisher = ps.executeQueryAsyncOracle();
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
        return Helper.first(publisher, context).compose(ors -> {
            try {
                return RowReader.create(ors, this.command.collector(), context, this.command.resultHandler());
            }
            catch (SQLException e) {
                return context.failedFuture((Throwable)e);
            }
        }).compose(rr -> rr.read(this.command.fetch())).mapEmpty();
    }
}

