/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.oracleclient.impl.commands.QueryCommand;
import io.vertx.sqlclient.Row;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.concurrent.Flow;
import java.util.stream.Collector;
import oracle.jdbc.OraclePreparedStatement;

public class SimpleQueryCommand<C, R>
extends QueryCommand<C, R> {
    private final String sql;

    public SimpleQueryCommand(String sql, Collector<Row, C, R> collector) {
        super(collector);
        this.sql = sql;
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return null;
    }

    @Override
    protected boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        return false;
    }

    @Override
    protected String query() {
        return this.sql;
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
    }

    @Override
    protected Future<OracleResponse<R>> doExecute(OraclePreparedStatement ps, ContextInternal context, boolean returnAutoGeneratedKeys) {
        Flow.Publisher publisher;
        try {
            publisher = ps.executeAsyncOracle();
        }
        catch (SQLException e) {
            return context.failedFuture((Throwable)e);
        }
        return Helper.first(publisher, context).compose(returnedResultSet -> Helper.executeBlocking((Context)context, () -> this.decode((Statement)ps, (boolean)returnedResultSet, returnAutoGeneratedKeys)));
    }
}

