/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleConnectionImpl;
import io.vertx.oracleclient.impl.OracleDatabaseHelper;
import io.vertx.oracleclient.impl.OracleJdbcConnection;
import io.vertx.oracleclient.impl.OracleMetadata;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnectionFactory
implements ConnectionFactory {
    private final OracleConnectOptions options;
    private final OracleDataSource datasource;

    public OracleConnectionFactory(VertxInternal vertx, OracleConnectOptions options) {
        this.options = options;
        this.datasource = OracleDatabaseHelper.createDataSource(options);
    }

    public void close(Promise<Void> promise) {
        promise.complete();
    }

    public Future<SqlConnection> connect(Context context) {
        ContextInternal ctx = (ContextInternal)context;
        QueryTracer tracer = ctx.tracer() == null ? null : new QueryTracer(ctx.tracer(), (SqlConnectOptions)this.options);
        return Helper.executeBlocking(context, () -> {
            OracleConnection orac = this.datasource.createConnectionBuilder().build();
            OracleMetadata metadata = new OracleMetadata(orac.getMetaData());
            OracleJdbcConnection conn = new OracleJdbcConnection(ctx, this.options, orac, metadata);
            OracleConnectionImpl msConn = new OracleConnectionImpl(ctx, this, conn, tracer, null);
            conn.init((Connection.Holder)msConn);
            return msConn;
        });
    }
}

