/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.spi;

import io.vertx.core.Closeable;
import io.vertx.core.Future;
import io.vertx.core.Vertx;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.OraclePool;
import io.vertx.oracleclient.impl.OracleConnectionFactory;
import io.vertx.oracleclient.impl.OracleConnectionImpl;
import io.vertx.oracleclient.impl.OracleConnectionUriParser;
import io.vertx.oracleclient.impl.OracleJdbcConnection;
import io.vertx.oracleclient.impl.OraclePoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolImpl;
import io.vertx.sqlclient.impl.SqlConnectionInternal;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import io.vertx.sqlclient.spi.Driver;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;

public class OracleDriver
implements Driver {
    private static final String SHARED_CLIENT_KEY = "__vertx.shared.oracleclient";
    public static final OracleDriver INSTANCE = new OracleDriver();

    public OraclePool newPool(Vertx vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        VertxInternal vx = (VertxInternal)vertx;
        PoolImpl pool = options.isShared() ? (PoolImpl)vx.createSharedClient(SHARED_CLIENT_KEY, options.getName(), closeFuture, cf -> this.newPoolImpl(vx, databases, options, (CloseFuture)cf)) : this.newPoolImpl(vx, databases, options, closeFuture);
        return new OraclePoolImpl(vx, closeFuture, (Pool)pool);
    }

    private PoolImpl newPoolImpl(VertxInternal vertx, List<? extends SqlConnectOptions> databases, PoolOptions options, CloseFuture closeFuture) {
        OracleConnectOptions baseConnectOptions = OracleConnectOptions.wrap(databases.get(0));
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        Function<Connection, Future> afterAcquire = conn -> ((OracleJdbcConnection)conn).afterAcquire();
        Function<Connection, Future> beforeRecycle = conn -> ((OracleJdbcConnection)conn).beforeRecycle();
        PoolImpl pool = new PoolImpl(vertx, (Driver)this, tracer, metrics, 1, options, afterAcquire, beforeRecycle, closeFuture);
        List lst = databases.stream().map(o -> this.createConnectionFactory((Vertx)vertx, (SqlConnectOptions)o)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        pool.init();
        closeFuture.add((Closeable)factory);
        return pool;
    }

    public OracleConnectOptions parseConnectionUri(String uri) {
        JsonObject conf = OracleConnectionUriParser.parse(uri, false);
        return conf == null ? null : new OracleConnectOptions(conf);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof OracleConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    public ConnectionFactory createConnectionFactory(Vertx vertx, SqlConnectOptions database) {
        return new OracleConnectionFactory((VertxInternal)vertx, OracleConnectOptions.wrap(database));
    }

    public SqlConnectionInternal wrapConnection(ContextInternal context, ConnectionFactory factory, Connection conn, QueryTracer tracer, ClientMetrics metrics) {
        return new OracleConnectionImpl(context, factory, conn, tracer, metrics);
    }
}

