package io.vertx.oracleclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.impl.JsonUtil;
import java.time.Instant;
import java.time.format.DateTimeFormatter;
import java.util.Base64;

/**
 * Converter and mapper for {@link io.vertx.oracleclient.OraclePrepareOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OraclePrepareOptions} original class using Vert.x codegen.
 */
public class OraclePrepareOptionsConverter {


  private static final Base64.Decoder BASE64_DECODER = JsonUtil.BASE64_DECODER;
  private static final Base64.Encoder BASE64_ENCODER = JsonUtil.BASE64_ENCODER;

  public static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, OraclePrepareOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "autoGeneratedKeys":
          if (member.getValue() instanceof Boolean) {
            obj.setAutoGeneratedKeys((Boolean)member.getValue());
          }
          break;
        case "autoGeneratedKeysIndexes":
          if (member.getValue() instanceof JsonArray) {
            obj.setAutoGeneratedKeysIndexes(((JsonArray)member.getValue()).copy());
          }
          break;
      }
    }
  }

  public static void toJson(OraclePrepareOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

  public static void toJson(OraclePrepareOptions obj, java.util.Map<String, Object> json) {
    json.put("autoGeneratedKeys", obj.isAutoGeneratedKeys());
    if (obj.getAutoGeneratedKeysIndexes() != null) {
      json.put("autoGeneratedKeysIndexes", obj.getAutoGeneratedKeysIndexes());
    }
  }
}
