/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.spi.OracleDriver;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnection;
import java.util.Collections;
import java.util.function.Function;
import java.util.function.Supplier;

@VertxGen
public interface OraclePool
extends Pool {
    public static OraclePool pool(OracleConnectOptions connectOptions, PoolOptions poolOptions) {
        return OraclePool.pool(null, connectOptions, poolOptions);
    }

    public static OraclePool pool(Vertx vertx, OracleConnectOptions connectOptions, PoolOptions poolOptions) {
        return (OraclePool)OracleDriver.INSTANCE.createPool(vertx, Collections.singletonList(connectOptions), poolOptions);
    }

    public static OraclePool pool(String connectionUri, PoolOptions poolOptions) {
        return OraclePool.pool(OracleConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static OraclePool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return OraclePool.pool(vertx, OracleConnectOptions.fromUri(connectionUri), poolOptions);
    }

    @GenIgnore(value={"permitted-type"})
    public static OraclePool pool(Supplier<Future<OracleConnectOptions>> databases, PoolOptions poolOptions) {
        return OraclePool.pool(null, databases, poolOptions);
    }

    @GenIgnore(value={"permitted-type"})
    public static OraclePool pool(Vertx vertx, Supplier<Future<OracleConnectOptions>> databases, PoolOptions poolOptions) {
        return (OraclePool)OracleDriver.INSTANCE.createPool(vertx, databases, poolOptions);
    }

    public OraclePool connectHandler(Handler<SqlConnection> var1);

    public OraclePool connectionProvider(Function<Context, Future<SqlConnection>> var1);
}

