/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.oracleclient.OraclePrepareOptionsConverter;
import io.vertx.sqlclient.PrepareOptions;
import java.util.Map;

@DataObject(generateConverter=true, inheritConverter=true)
public class OraclePrepareOptions
extends PrepareOptions {
    public static final boolean DEFAULT_AUTO_GENERATED_KEY = true;
    private boolean autoGeneratedKeys = true;
    private JsonArray autoGeneratedKeysIndexes;

    public OraclePrepareOptions() {
    }

    public OraclePrepareOptions(OraclePrepareOptions options) {
        super((PrepareOptions)options);
        this.autoGeneratedKeys = options.autoGeneratedKeys;
        this.autoGeneratedKeysIndexes = options.autoGeneratedKeysIndexes != null ? options.autoGeneratedKeysIndexes.copy() : null;
    }

    public OraclePrepareOptions(JsonObject json) {
        super(json);
        OraclePrepareOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public static OraclePrepareOptions createFrom(PrepareOptions prepareOptions) {
        OraclePrepareOptions oraclePrepareOptions = prepareOptions == null ? null : (prepareOptions instanceof OraclePrepareOptions ? new OraclePrepareOptions((OraclePrepareOptions)prepareOptions) : new OraclePrepareOptions(prepareOptions.toJson()));
        return oraclePrepareOptions;
    }

    public boolean isAutoGeneratedKeys() {
        return this.autoGeneratedKeys;
    }

    public OraclePrepareOptions setAutoGeneratedKeys(boolean autoGeneratedKeys) {
        this.autoGeneratedKeys = autoGeneratedKeys;
        return this;
    }

    public JsonArray getAutoGeneratedKeysIndexes() {
        return this.autoGeneratedKeysIndexes;
    }

    public OraclePrepareOptions setAutoGeneratedKeysIndexes(JsonArray autoGeneratedKeysIndexes) {
        this.autoGeneratedKeysIndexes = autoGeneratedKeysIndexes;
        return this;
    }

    public JsonObject toJson() {
        JsonObject jsonObject = new JsonObject();
        OraclePrepareOptionsConverter.toJson(this, jsonObject);
        return jsonObject;
    }

    public String toString() {
        return "OraclePrepareOptions{autoGeneratedKeys=" + this.autoGeneratedKeys + ", autoGeneratedKeysIndexes=" + this.autoGeneratedKeysIndexes + "}";
    }
}

