/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.impl.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.commands.OracleQueryCommand;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.QueryResultHandler;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;

public class OraclePreparedQueryCommand<C, R>
extends OracleQueryCommand<C, R> {
    private final String sql;
    private final Tuple params;
    private final PrepareOptions prepareOptions;
    private final QueryResultHandler<R> resultHandler;

    public OraclePreparedQueryCommand(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<R> cmd, Collector<Row, C, R> collector) {
        super(oracleConnection, connectionContext, collector);
        this.sql = cmd.sql();
        this.params = cmd.params();
        this.prepareOptions = cmd.options();
        this.resultHandler = cmd.resultHandler();
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return OraclePrepareOptions.createFrom(this.prepareOptions);
    }

    @Override
    protected String query() {
        return this.sql;
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    @Override
    protected Future<Boolean> doExecute(OraclePreparedStatement ps, boolean returnAutoGeneratedKeys) {
        return this.executeBlocking(() -> ((OraclePreparedStatement)ps).executeAsyncOracle()).compose(pub -> this.first(pub)).compose(returnedResultSet -> this.executeBlocking(() -> this.decode((Statement)ps, (boolean)returnedResultSet, returnAutoGeneratedKeys))).map(oracleResponse -> {
            oracleResponse.handle(this.resultHandler);
            return false;
        });
    }
}

