/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.json.JsonArray;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleRow;
import io.vertx.oracleclient.impl.OracleRowDesc;
import io.vertx.oracleclient.impl.commands.OracleCommand;
import io.vertx.oracleclient.impl.commands.OracleResponse;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.desc.ColumnDescriptor;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.Date;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.ResultSetMetaData;
import java.sql.SQLException;
import java.sql.Statement;
import java.sql.Time;
import java.sql.Timestamp;
import java.time.Instant;
import java.time.LocalDate;
import java.time.LocalTime;
import java.util.function.BiConsumer;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.sql.TIMESTAMPTZ;

public abstract class OracleQueryCommand<C, R>
extends OracleCommand<Boolean> {
    private final Collector<Row, C, R> collector;

    protected OracleQueryCommand(OracleConnection oracleConnection, ContextInternal connectionContext, Collector<Row, C, R> collector) {
        super(oracleConnection, connectionContext);
        this.collector = collector;
    }

    @Override
    protected Future<Boolean> execute() {
        OraclePrepareOptions options = this.prepareOptions();
        boolean returnAutoGeneratedKeys = this.returnAutoGeneratedKeys((Connection)this.oracleConnection, options);
        Future<OraclePreparedStatement> psFuture = this.prepare((Connection)this.oracleConnection, options, returnAutoGeneratedKeys, (Context)this.connectionContext);
        return psFuture.compose(ps -> this.withPreparedStatement((OraclePreparedStatement)ps, this.connectionContext, returnAutoGeneratedKeys));
    }

    private Future<Boolean> withPreparedStatement(OraclePreparedStatement ps, ContextInternal context, boolean returnAutoGeneratedKeys) {
        return this.doExecute(ps, returnAutoGeneratedKeys).transform(ar -> {
            Future<Void> close = this.closeStatementAfterExecute() ? this.executeBlocking(() -> Helper.closeQuietly((AutoCloseable)ps)) : context.succeededFuture();
            if (ar.succeeded()) {
                return close.map((Object)((Boolean)ar.result()));
            }
            return close.transform(v -> context.failedFuture(ar.cause()));
        });
    }

    protected boolean closeStatementAfterExecute() {
        return true;
    }

    protected abstract OraclePrepareOptions prepareOptions();

    protected boolean returnAutoGeneratedKeys(Connection conn, OraclePrepareOptions options) {
        boolean autoGeneratedIndexes;
        boolean autoGeneratedKeys = options != null && options.isAutoGeneratedKeys();
        boolean bl = autoGeneratedIndexes = options != null && options.getAutoGeneratedKeysIndexes() != null && options.getAutoGeneratedKeysIndexes().size() > 0;
        if (autoGeneratedKeys || autoGeneratedIndexes) {
            try {
                DatabaseMetaData dbmd = conn.getMetaData();
                if (dbmd != null) {
                    return dbmd.supportsGetGeneratedKeys();
                }
            }
            catch (SQLException sQLException) {
                // empty catch block
            }
        }
        return false;
    }

    protected abstract String query();

    private Future<OraclePreparedStatement> prepare(Connection conn, OraclePrepareOptions options, boolean returnAutoGeneratedKeys, Context context) {
        return context.executeBlocking(prom -> {
            String query = this.query();
            PreparedStatement ps = null;
            try {
                boolean autoGeneratedIndexes = this.isAutoGeneratedIndexes(options);
                if (returnAutoGeneratedKeys && !autoGeneratedIndexes) {
                    ps = conn.prepareStatement(query, 1);
                } else if (autoGeneratedIndexes) {
                    JsonArray indexes = options.getAutoGeneratedKeysIndexes();
                    if (indexes.getValue(0) instanceof Number) {
                        int[] keys = new int[indexes.size()];
                        for (int i = 0; i < keys.length; ++i) {
                            keys[i] = indexes.getInteger(i);
                        }
                        ps = conn.prepareStatement(query, keys);
                    } else {
                        if (!(indexes.getValue(0) instanceof String)) {
                            prom.fail("Invalid type of index, only [int, String] allowed");
                            return;
                        }
                        String[] keys = new String[indexes.size()];
                        for (int i = 0; i < keys.length; ++i) {
                            keys[i] = indexes.getString(i);
                        }
                        ps = conn.prepareStatement(query, keys);
                    }
                } else {
                    ps = conn.prepareStatement(this.query());
                }
                this.fillStatement(ps, conn);
                prom.complete((Object)ps.unwrap(OraclePreparedStatement.class));
                return;
            }
            catch (SQLException e) {
                Helper.closeQuietly(ps);
                prom.fail((Throwable)e);
            }
        }, false);
    }

    private boolean isAutoGeneratedIndexes(OraclePrepareOptions options) {
        return options != null && options.getAutoGeneratedKeysIndexes() != null && options.getAutoGeneratedKeysIndexes().size() > 0;
    }

    protected abstract void fillStatement(PreparedStatement var1, Connection var2) throws SQLException;

    protected Object adaptType(Connection conn, Object value) throws SQLException {
        if (value instanceof LocalTime) {
            LocalTime time = (LocalTime)value;
            return Time.valueOf(time);
        }
        if (value instanceof LocalDate) {
            LocalDate date = (LocalDate)value;
            return Date.valueOf(date);
        }
        if (value instanceof Instant) {
            Instant timestamp = (Instant)value;
            return Timestamp.from(timestamp);
        }
        if (value instanceof io.vertx.oracleclient.data.Blob) {
            io.vertx.oracleclient.data.Blob blob = (io.vertx.oracleclient.data.Blob)value;
            Blob javaBlob = conn.createBlob();
            javaBlob.setBytes(1L, blob.bytes);
            return javaBlob;
        }
        if (value instanceof Buffer) {
            Buffer buffer = (Buffer)value;
            return buffer.getBytes();
        }
        return value;
    }

    protected abstract Future<Boolean> doExecute(OraclePreparedStatement var1, boolean var2);

    protected OracleResponse<R> decode(Statement statement, boolean returnedResultSet, boolean returnedKeys) throws SQLException {
        OracleResponse<R> response = new OracleResponse<R>(statement.getUpdateCount());
        if (returnedResultSet) {
            while (returnedResultSet) {
                try (ResultSet rs = statement.getResultSet();){
                    this.decodeResultSet(rs, response);
                }
                if (returnedKeys) {
                    this.decodeReturnedKeys(statement, response);
                }
                returnedResultSet = statement.getMoreResults();
            }
        } else {
            this.collector.accumulator();
            C container = this.collector.supplier().get();
            response.empty(this.collector.finisher().apply(container));
            if (returnedKeys) {
                this.decodeReturnedKeys(statement, response);
            }
        }
        return response;
    }

    protected OracleResponse<R> decode(Statement statement, int[] returnedBatchResult, boolean returnedKeys) throws SQLException {
        OracleResponse<R> response = new OracleResponse<R>(returnedBatchResult.length);
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        OracleRowDesc desc = OracleRowDesc.EMPTY;
        C container = this.collector.supplier().get();
        for (int result : returnedBatchResult) {
            OracleRow row = new OracleRow(desc);
            row.addValue(result);
            accumulator.accept(container, (Row)row);
        }
        response.push(this.collector.finisher().apply(container), desc, returnedBatchResult.length);
        if (returnedKeys) {
            this.decodeReturnedKeys(statement, response);
        }
        return response;
    }

    private void decodeResultSet(ResultSet rs, OracleResponse<R> response) throws SQLException {
        BiConsumer<C, Row> accumulator = this.collector.accumulator();
        C container = this.collector.supplier().get();
        int size = 0;
        ResultSetMetaData metaData = rs.getMetaData();
        OracleRowDesc desc = OracleRowDesc.create(metaData);
        while (rs.next()) {
            ++size;
            OracleRow row = new OracleRow(desc);
            for (int i = 1; i <= metaData.getColumnCount(); ++i) {
                Object res = Helper.convertSqlValue(rs.getObject(i));
                row.addValue(res);
            }
            accumulator.accept(container, (Row)row);
        }
        response.push(this.collector.finisher().apply(container), desc, size);
    }

    private void decodeReturnedKeys(Statement statement, OracleResponse<R> response) throws SQLException {
        int cols;
        ResultSetMetaData metaData;
        ResultSet keysRS = statement.getGeneratedKeys();
        if (keysRS != null && keysRS.next() && (metaData = keysRS.getMetaData()) != null && (cols = metaData.getColumnCount()) > 0) {
            OracleRowDesc keysDesc = OracleRowDesc.create(metaData);
            OracleRow keys = new OracleRow(keysDesc);
            for (int i = 1; i <= cols; ++i) {
                Object res;
                ColumnDescriptor columnDesc = (ColumnDescriptor)keysDesc.columnDescriptor().get(i - 1);
                switch (columnDesc.jdbcType()) {
                    case TIMESTAMP: {
                        res = Helper.convertSqlValue(keysRS.getObject(i, Timestamp.class));
                        break;
                    }
                    case TIMESTAMP_WITH_TIMEZONE: {
                        res = Helper.convertSqlValue(keysRS.getObject(i, TIMESTAMPTZ.class));
                        break;
                    }
                    default: {
                        res = Helper.convertSqlValue(keysRS.getObject(i));
                    }
                }
                keys.addValue(res);
            }
            response.returnedKeys((Row)keys);
        }
    }
}

