/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.VertxException;
import io.vertx.core.buffer.Buffer;
import io.vertx.oracleclient.OracleException;
import io.vertx.sqlclient.Tuple;
import java.lang.reflect.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLFeatureNotSupportedException;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.concurrent.Callable;
import java.util.function.Function;
import java.util.function.Supplier;
import oracle.sql.TIMESTAMPTZ;

public class Helper {
    public static void closeQuietly(AutoCloseable autoCloseable) {
        if (autoCloseable != null) {
            try {
                autoCloseable.close();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public static <T> T getOrHandleSQLException(ThrowingSupplier<T> supplier) throws VertxException {
        try {
            return supplier.getOrThrow();
        }
        catch (SQLException sqlException) {
            throw new OracleException(sqlException);
        }
    }

    public static void runOrHandleSQLException(ThrowingRunnable runnable) throws VertxException {
        try {
            runnable.runOrThrow();
        }
        catch (SQLException sqlException) {
            throw new OracleException(sqlException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static Object convertSqlValue(Object value) throws SQLException {
        if (value == null) {
            return null;
        }
        if (value instanceof Boolean || value instanceof String || value instanceof Number) {
            return value;
        }
        if (value instanceof byte[]) {
            return Buffer.buffer((byte[])((byte[])value));
        }
        if (value instanceof Time) {
            return ((Time)value).toLocalTime();
        }
        if (value instanceof Date) {
            return ((Date)value).toLocalDate();
        }
        if (value instanceof Timestamp) {
            return ((Timestamp)value).toLocalDateTime();
        }
        if (value instanceof TIMESTAMPTZ) {
            return ((TIMESTAMPTZ)value).toZonedDateTime().toOffsetDateTime();
        }
        if (value instanceof Clob) {
            Clob c = (Clob)value;
            try {
                String string = c.getSubString(1L, (int)c.length());
                return string;
            }
            finally {
                try {
                    c.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof Blob) {
            Blob b = (Blob)value;
            try {
                Buffer buffer = Buffer.buffer((byte[])b.getBytes(1L, (int)b.length()));
                return buffer;
            }
            finally {
                try {
                    b.free();
                }
                catch (AbstractMethodError | SQLFeatureNotSupportedException throwable) {}
            }
        }
        if (value instanceof java.sql.Array) {
            java.sql.Array a = (java.sql.Array)value;
            try {
                Object arr = a.getArray();
                if (arr != null) {
                    int len = Array.getLength(arr);
                    Object[] castedArray = new Object[len];
                    for (int i = 0; i < len; ++i) {
                        castedArray[i] = Helper.convertSqlValue(Array.get(arr, i));
                    }
                    Object[] objectArray = castedArray;
                    return objectArray;
                }
            }
            finally {
                a.free();
            }
        }
        if (value instanceof RowId) {
            return ((RowId)value).getBytes();
        }
        if (value instanceof Struct) {
            return Tuple.of((Object)((Struct)value).getAttributes());
        }
        return value.toString();
    }

    public static boolean isFatal(SQLException e) {
        int errorCode = e.getErrorCode();
        return errorCode == 28 || errorCode == 600 || errorCode == 1012 || errorCode == 1014 || errorCode == 1033 || errorCode == 1034 || errorCode == 1035 || errorCode == 1089 || errorCode == 1090 || errorCode == 1092 || errorCode == 1094 || errorCode == 2396 || errorCode == 3106 || errorCode == 3111 || errorCode == 3113 || errorCode == 3114 || errorCode >= 12100 && errorCode <= 12299 || errorCode == 17002 || errorCode == 17008 || errorCode == 17410 || errorCode == 17447 || "08000".equals(e.getSQLState());
    }

    public static <T> Future<T> executeBlocking(Context context, SQLBlockingCodeHandler<T> blockingCodeHandler) {
        return context.executeBlocking(blockingCodeHandler, false);
    }

    public static Future<Void> executeBlocking(Context context, SQLBlockingTaskHandler blockingTaskHandler) {
        return context.executeBlocking((Callable)blockingTaskHandler, false);
    }

    @FunctionalInterface
    public static interface SQLFutureMapper<T, U>
    extends Function<T, Future<U>> {
        public Future<U> doApply(T var1) throws SQLException;

        @Override
        default public Future<U> apply(T t) {
            try {
                return this.doApply(t);
            }
            catch (SQLException e) {
                return Future.failedFuture((Throwable)((Object)new OracleException(e)));
            }
        }
    }

    @FunctionalInterface
    public static interface SQLBlockingTaskHandler
    extends Callable<Void> {
        public void doHandle() throws SQLException;

        @Override
        default public Void call() throws Exception {
            try {
                this.doHandle();
                return null;
            }
            catch (SQLException e) {
                throw new OracleException(e);
            }
        }
    }

    @FunctionalInterface
    public static interface SQLBlockingCodeHandler<T>
    extends Callable<T> {
        public T doHandle() throws SQLException;

        @Override
        default public T call() {
            try {
                return this.doHandle();
            }
            catch (SQLException e) {
                throw new OracleException(e);
            }
        }
    }

    static interface JdbcRow {
        public <T> T getObject(int var1, Class<T> var2);

        public JdbcRow copy();
    }

    @FunctionalInterface
    public static interface ThrowingRunnable
    extends Runnable {
        public void runOrThrow() throws SQLException;

        @Override
        default public void run() throws VertxException {
            Helper.runOrHandleSQLException(this);
        }
    }

    @FunctionalInterface
    public static interface ThrowingSupplier<T>
    extends Supplier<T> {
        public T getOrThrow() throws SQLException;

        @Override
        default public T get() throws VertxException {
            return Helper.getOrHandleSQLException(this);
        }
    }
}

