/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl;

import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Promise;
import io.vertx.core.internal.ContextInternal;
import io.vertx.core.internal.VertxInternal;
import io.vertx.core.json.JsonObject;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.oracleclient.OracleConnectOptions;
import io.vertx.oracleclient.impl.Helper;
import io.vertx.oracleclient.impl.OracleConnectionImpl;
import io.vertx.oracleclient.impl.OracleDatabaseHelper;
import io.vertx.oracleclient.impl.OracleJdbcConnection;
import io.vertx.oracleclient.impl.OracleMetadata;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.internal.Connection;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.HashMap;
import java.util.Map;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.datasource.OracleDataSource;

public class OracleConnectionFactory
implements ConnectionFactory<OracleConnectOptions> {
    private final Map<JsonObject, OracleDataSource> datasources = new HashMap<JsonObject, OracleDataSource>();

    public OracleConnectionFactory(VertxInternal vertx) {
    }

    public void close(Promise<Void> promise) {
        promise.complete();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OracleDataSource getDatasource(SqlConnectOptions options) {
        OracleDataSource datasource;
        JsonObject key = options.toJson();
        OracleConnectionFactory oracleConnectionFactory = this;
        synchronized (oracleConnectionFactory) {
            datasource = this.datasources.get(key);
            if (datasource == null) {
                datasource = OracleDatabaseHelper.createDataSource((OracleConnectOptions)options);
                this.datasources.put(key, datasource);
            }
        }
        return datasource;
    }

    public Future<SqlConnection> connect(Context context, OracleConnectOptions options) {
        OracleDataSource datasource = this.getDatasource(options);
        VertxMetrics vertxMetrics = ((VertxInternal)context.owner()).metrics();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(options.getSocketAddress(), "sql", options.getMetricsName()) : null;
        ContextInternal ctx = (ContextInternal)context;
        return Helper.executeBlocking(context, () -> {
            OracleConnection orac = datasource.createConnectionBuilder().build();
            OracleMetadata metadata = new OracleMetadata(orac.getMetaData());
            OracleJdbcConnection conn = new OracleJdbcConnection(ctx, metrics, options, orac, metadata);
            OracleConnectionImpl msConn = new OracleConnectionImpl(ctx, this, conn);
            conn.init((Connection.Holder)msConn);
            return msConn;
        });
    }
}

