/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.oracleclient.impl.commands;

import io.vertx.core.Future;
import io.vertx.core.internal.ContextInternal;
import io.vertx.oracleclient.OraclePrepareOptions;
import io.vertx.oracleclient.impl.RowReader;
import io.vertx.oracleclient.impl.commands.OracleQueryCommand;
import io.vertx.sqlclient.PrepareOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.internal.QueryResultHandler;
import io.vertx.sqlclient.internal.command.ExtendedQueryCommand;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.SQLException;
import java.util.function.Consumer;
import java.util.stream.Collector;
import oracle.jdbc.OracleConnection;
import oracle.jdbc.OraclePreparedStatement;
import oracle.jdbc.OracleResultSet;

public class OracleCursorQueryCommand<C, R>
extends OracleQueryCommand<C, R> {
    private final String sql;
    private final int fetch;
    private final Tuple params;
    private final PrepareOptions prepareOptions;
    private final Consumer<RowReader<C, R>> store;
    private final Collector<Row, C, R> collector;
    private final QueryResultHandler<R> resultHandler;

    private OracleCursorQueryCommand(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<R> cmd, Collector<Row, C, R> collector, Consumer<RowReader<C, R>> store) {
        super(oracleConnection, connectionContext, collector);
        this.sql = cmd.sql();
        this.fetch = cmd.fetch();
        this.params = cmd.params();
        this.prepareOptions = cmd.options();
        this.resultHandler = cmd.resultHandler();
        this.collector = collector;
        this.store = store;
    }

    public static <U, V> OracleCursorQueryCommand<U, V> create(OracleConnection oracleConnection, ContextInternal connectionContext, ExtendedQueryCommand<V> cmd, Collector<Row, U, V> collector, Consumer<RowReader<U, V>> store) {
        return new OracleCursorQueryCommand<U, V>(oracleConnection, connectionContext, cmd, collector, store);
    }

    @Override
    protected boolean closeStatementAfterExecute() {
        return false;
    }

    @Override
    protected OraclePrepareOptions prepareOptions() {
        return OraclePrepareOptions.createFrom(this.prepareOptions);
    }

    @Override
    protected String query() {
        return this.sql;
    }

    @Override
    protected void fillStatement(PreparedStatement ps, Connection conn) throws SQLException {
        for (int i = 0; i < this.params.size(); ++i) {
            Object value = this.adaptType(conn, this.params.getValue(i));
            ps.setObject(i + 1, value);
        }
    }

    @Override
    protected Future<Boolean> doExecute(OraclePreparedStatement ps, boolean returnAutoGeneratedKeys) {
        return this.executeBlocking(() -> ((OraclePreparedStatement)ps).executeQueryAsyncOracle()).compose(pub -> this.first(pub)).compose(ors -> this.executeBlocking(() -> new RowReader<C, R>(this.connectionContext, this.collector, (OracleResultSet)ors))).compose(rr -> {
            this.store.accept((RowReader<C, R>)rr);
            return rr.read(this.fetch).compose(oracleResponse -> {
                oracleResponse.handle(this.resultHandler);
                return rr.hasMore();
            });
        });
    }
}

