package io.vertx.oracleclient;

import io.vertx.core.json.JsonObject;
import io.vertx.core.json.JsonArray;
import java.time.Instant;
import java.time.format.DateTimeFormatter;

/**
 * Converter and mapper for {@link io.vertx.oracleclient.OracleConnectOptions}.
 * NOTE: This class has been automatically generated from the {@link io.vertx.oracleclient.OracleConnectOptions} original class using Vert.x codegen.
 */
public class OracleConnectOptionsConverter {

   static void fromJson(Iterable<java.util.Map.Entry<String, Object>> json, OracleConnectOptions obj) {
    for (java.util.Map.Entry<String, Object> member : json) {
      switch (member.getKey()) {
        case "serviceId":
          if (member.getValue() instanceof String) {
            obj.setServiceId((String)member.getValue());
          }
          break;
        case "serviceName":
          if (member.getValue() instanceof String) {
            obj.setServiceName((String)member.getValue());
          }
          break;
        case "serverMode":
          if (member.getValue() instanceof String) {
            obj.setServerMode(io.vertx.oracleclient.ServerMode.valueOf((String)member.getValue()));
          }
          break;
        case "instanceName":
          if (member.getValue() instanceof String) {
            obj.setInstanceName((String)member.getValue());
          }
          break;
        case "tnsAlias":
          if (member.getValue() instanceof String) {
            obj.setTnsAlias((String)member.getValue());
          }
          break;
        case "tnsAdmin":
          if (member.getValue() instanceof String) {
            obj.setTnsAdmin((String)member.getValue());
          }
          break;
        case "ssl":
          if (member.getValue() instanceof Boolean) {
            obj.setSsl((Boolean)member.getValue());
          }
          break;
      }
    }
  }

   static void toJson(OracleConnectOptions obj, JsonObject json) {
    toJson(obj, json.getMap());
  }

   static void toJson(OracleConnectOptions obj, java.util.Map<String, Object> json) {
    if (obj.getServiceId() != null) {
      json.put("serviceId", obj.getServiceId());
    }
    if (obj.getServiceName() != null) {
      json.put("serviceName", obj.getServiceName());
    }
    if (obj.getServerMode() != null) {
      json.put("serverMode", obj.getServerMode().name());
    }
    if (obj.getInstanceName() != null) {
      json.put("instanceName", obj.getInstanceName());
    }
    if (obj.getTnsAlias() != null) {
      json.put("tnsAlias", obj.getTnsAlias());
    }
    if (obj.getTnsAdmin() != null) {
      json.put("tnsAdmin", obj.getTnsAdmin());
    }
    json.put("ssl", obj.isSsl());
  }
}
