/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.core.Handler;
import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.impl.TxStatus;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;

abstract class PgCommandCodec<R, C extends CommandBase<R>> {
    private static final Logger logger = LoggerFactory.getLogger(PgCommandCodec.class);
    Handler<? super CommandResponse<R>> completionHandler;
    Handler<NoticeResponse> noticeHandler;
    Throwable failure;
    R result;
    final C cmd;

    PgCommandCodec(C cmd) {
        this.cmd = cmd;
    }

    abstract void encode(PgEncoder var1);

    void handleBackendKeyData(int processId, int secretKey) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BackendKeyData"));
    }

    void handleEmptyQueryResponse() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message EmptyQueryResponse"));
    }

    void handleParameterDescription(PgParamDesc paramDesc) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParameterDescription"));
    }

    void handleParseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParseComplete"));
    }

    void handleCloseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CloseComplete"));
    }

    void handleRowDescription(PgRowDesc rowDescription) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + (Object)((Object)rowDescription)));
    }

    void handleNoData() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message NoData"));
    }

    void handleNoticeResponse(NoticeResponse noticeResponse) {
        this.noticeHandler.handle((Object)noticeResponse);
    }

    void handleErrorResponse(ErrorResponse errorResponse) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + errorResponse));
    }

    void handlePortalSuspended() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message PortalSuspended"));
    }

    void handleBindComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BindComplete"));
    }

    void handleCommandComplete(int updated) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CommandComplete"));
    }

    void handleAuthenticationMD5Password(byte[] salt) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationMD5Password"));
    }

    void handleAuthenticationClearTextPassword() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationClearTextPassword"));
    }

    void handleAuthenticationOk() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationOk"));
    }

    void handleParameterStatus(String key, String value) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParameterStatus"));
    }

    void handleReadyForQuery(TxStatus txStatus) {
        CommandResponse resp = this.failure != null ? CommandResponse.failure((Throwable)this.failure, (TxStatus)txStatus) : CommandResponse.success(this.result, (TxStatus)txStatus);
        this.completionHandler.handle((Object)resp);
    }
}

