/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.Bind;
import io.vertx.pgclient.impl.codec.DataFormat;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.PreparedStatement;
import java.util.Arrays;
import java.util.List;

class PgPreparedStatement
implements PreparedStatement {
    private static final PgColumnDesc[] EMPTY_COLUMNS = new PgColumnDesc[0];
    final String sql;
    final Bind bind;
    final PgParamDesc paramDesc;
    final PgRowDesc rowDesc;

    PgPreparedStatement(String sql, long statement, PgParamDesc paramDesc, PgRowDesc rowDesc) {
        if (rowDesc != null) {
            rowDesc = new PgRowDesc((PgColumnDesc[])Arrays.stream(rowDesc.columns).map(c -> new PgColumnDesc(c.name, c.relationId, c.relationAttributeNo, c.dataType, c.length, c.typeModifier, c.dataType.supportsBinary ? DataFormat.BINARY : DataFormat.TEXT)).toArray(PgColumnDesc[]::new));
        }
        this.paramDesc = paramDesc;
        this.rowDesc = rowDesc;
        this.sql = sql;
        this.bind = new Bind(statement, paramDesc != null ? paramDesc.paramDataTypes() : null, rowDesc != null ? rowDesc.columns : EMPTY_COLUMNS);
    }

    public ParamDesc paramDesc() {
        return this.paramDesc;
    }

    public PgRowDesc rowDesc() {
        return this.rowDesc;
    }

    public String sql() {
        return this.sql;
    }

    public String prepare(List<Object> values) {
        return this.paramDesc.prepare(values);
    }
}

