/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.math.BigDecimal;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.temporal.Temporal;
import java.util.Collection;
import java.util.List;
import java.util.UUID;

public class RowImpl
extends ArrayTuple
implements Row {
    private final RowDesc desc;

    public RowImpl(RowDesc desc) {
        super(desc.columnNames().size());
        this.desc = desc;
    }

    public RowImpl(RowImpl row) {
        super((Collection)((Object)row));
        this.desc = row.desc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.desc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.desc.columnNames().indexOf(name);
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Character.class) {
            return type.cast(this.getChar(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == UUID.class) {
            return type.cast(this.getUUID(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(pos));
        }
        if (type == OffsetTime.class) {
            return type.cast(this.getOffsetTime(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == OffsetDateTime.class) {
            return type.cast(this.getOffsetDateTime(pos));
        }
        if (type == Interval.class) {
            return type.cast(this.getInterval(pos));
        }
        if (type == Point.class) {
            return type.cast(this.getPoint(pos));
        }
        if (type == Line.class) {
            return type.cast(this.getLine(pos));
        }
        if (type == LineSegment.class) {
            return type.cast(this.getLineSegment(pos));
        }
        if (type == Path.class) {
            return type.cast(this.getPath(pos));
        }
        if (type == Polygon.class) {
            return type.cast(this.getPolygon(pos));
        }
        if (type == Circle.class) {
            return type.cast(this.getCircle(pos));
        }
        if (type == Box.class) {
            return type.cast(this.getBox(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == Object.class) {
            return type.cast(this.get(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return this.getBooleanArray(pos);
        }
        if (type == Short.class) {
            return this.getShortArray(pos);
        }
        if (type == Integer.class) {
            return this.getIntegerArray(pos);
        }
        if (type == Long.class) {
            return this.getLongArray(pos);
        }
        if (type == Float.class) {
            return this.getFloatArray(pos);
        }
        if (type == Double.class) {
            return this.getDoubleArray(pos);
        }
        if (type == Character.class) {
            return this.getCharArray(pos);
        }
        if (type == String.class) {
            return this.getStringArray(pos);
        }
        if (type == Buffer.class) {
            return this.getBufferArray(pos);
        }
        if (type == UUID.class) {
            return this.getUUIDArray(pos);
        }
        if (type == LocalDate.class) {
            return this.getLocalDateArray(pos);
        }
        if (type == LocalTime.class) {
            return this.getLocalTimeArray(pos);
        }
        if (type == OffsetTime.class) {
            return this.getOffsetTimeArray(pos);
        }
        if (type == LocalDateTime.class) {
            return this.getLocalDateTimeArray(pos);
        }
        if (type == OffsetDateTime.class) {
            return this.getOffsetDateTimeArray(pos);
        }
        if (type == Interval.class) {
            return this.getIntervalArray(pos);
        }
        if (type == Numeric.class) {
            return this.getNumericArray(pos);
        }
        if (type == Point.class) {
            return this.getPointArray(pos);
        }
        if (type == Line.class) {
            return this.getLineArray(pos);
        }
        if (type == LineSegment.class) {
            return this.getLineSegmentArray(pos);
        }
        if (type == Path.class) {
            return this.getPathArray(pos);
        }
        if (type == Polygon.class) {
            return this.getPolygonArray(pos);
        }
        if (type == Circle.class) {
            return this.getCircleArray(pos);
        }
        if (type == Interval.class) {
            return this.getIntervalArray(pos);
        }
        if (type == Box.class) {
            return this.getBoxArray(pos);
        }
        if (type == Object.class) {
            return this.getJsonArray(pos);
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public Boolean getBoolean(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBoolean(pos);
    }

    public Object getValue(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getValue(pos);
    }

    public Short getShort(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getShort(pos);
    }

    public Integer getInteger(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getInteger(pos);
    }

    public Long getLong(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLong(pos);
    }

    public Float getFloat(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getFloat(pos);
    }

    public Double getDouble(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getDouble(pos);
    }

    public String getString(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getString(pos);
    }

    public Buffer getBuffer(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBuffer(pos);
    }

    public Temporal getTemporal(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getTemporal(pos);
    }

    public LocalDate getLocalDate(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDate(pos);
    }

    public LocalTime getLocalTime(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalTime(pos);
    }

    public LocalDateTime getLocalDateTime(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDateTime(pos);
    }

    public OffsetTime getOffsetTime(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getOffsetTime(pos);
    }

    public OffsetDateTime getOffsetDateTime(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getOffsetDateTime(pos);
    }

    public UUID getUUID(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getUUID(pos);
    }

    public BigDecimal getBigDecimal(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBigDecimal(pos);
    }

    public Numeric getNumeric(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getNumeric(pos);
    }

    public Point getPoint(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPoint(pos);
    }

    public Line getLine(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLine(pos);
    }

    public LineSegment getLineSegment(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineSegment(pos);
    }

    public Box getBox(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBox(pos);
    }

    public Path getPath(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPath(pos);
    }

    public Polygon getPolygon(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPolygon(pos);
    }

    public Circle getCircle(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCircle(pos);
    }

    public Interval getInterval(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getInterval(pos);
    }

    public Boolean[] getBooleanArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBooleanArray(pos);
    }

    public Short[] getShortArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getShortArray(pos);
    }

    public Integer[] getIntegerArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getIntegerArray(pos);
    }

    public Long[] getLongArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLongArray(pos);
    }

    public Float[] getFloatArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getFloatArray(pos);
    }

    public Double[] getDoubleArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getDoubleArray(pos);
    }

    public String[] getStringArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getStringArray(pos);
    }

    public LocalDate[] getLocalDateArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDateArray(pos);
    }

    public LocalTime[] getLocalTimeArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalTimeArray(pos);
    }

    public OffsetTime[] getOffsetTimeArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getOffsetTimeArray(pos);
    }

    public LocalDateTime[] getLocalDateTimeArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLocalDateTimeArray(pos);
    }

    public OffsetDateTime[] getOffsetDateTimeArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getOffsetDateTimeArray(pos);
    }

    public Buffer[] getBufferArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBufferArray(pos);
    }

    public UUID[] getUUIDArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getUUIDArray(pos);
    }

    public Object[] getJsonArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getJsonArray(pos);
    }

    public Numeric[] getNumericArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getNumericArray(pos);
    }

    public Point[] getPointArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPointArray(pos);
    }

    public Line[] getLineArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineArray(pos);
    }

    public LineSegment[] getLineSegmentArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineSegmentArray(pos);
    }

    public Box[] getBoxArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBoxArray(pos);
    }

    public Path[] getPathArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPathArray(pos);
    }

    public Polygon[] getPolygonArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPolygonArray(pos);
    }

    public Circle[] getCircleArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCircleArray(pos);
    }

    public Interval[] getIntervalArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getIntervalArray(pos);
    }

    public Character[] getCharArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCharArray(pos);
    }

    public Character getChar(int pos) {
        Object val = this.get(pos);
        if (val instanceof Character) {
            return (Character)val;
        }
        return null;
    }

    public Numeric getNumeric(int pos) {
        Object val = this.get(pos);
        if (val instanceof Numeric) {
            return (Numeric)val;
        }
        if (val instanceof Number) {
            return Numeric.parse((String)val.toString());
        }
        return null;
    }

    public Object getJson(int pos) {
        Object val = this.get(pos);
        if (val instanceof JsonObject) {
            return val;
        }
        if (val instanceof JsonArray) {
            return val;
        }
        return null;
    }

    public Point getPoint(int pos) {
        Object val = this.get(pos);
        if (val instanceof Point) {
            return (Point)val;
        }
        return null;
    }

    public Line getLine(int pos) {
        Object val = this.get(pos);
        if (val instanceof Line) {
            return (Line)val;
        }
        return null;
    }

    public LineSegment getLineSegment(int pos) {
        Object val = this.get(pos);
        if (val instanceof LineSegment) {
            return (LineSegment)val;
        }
        return null;
    }

    public Box getBox(int pos) {
        Object val = this.get(pos);
        if (val instanceof Box) {
            return (Box)val;
        }
        return null;
    }

    public Path getPath(int pos) {
        Object val = this.get(pos);
        if (val instanceof Path) {
            return (Path)val;
        }
        return null;
    }

    public Polygon getPolygon(int pos) {
        Object val = this.get(pos);
        if (val instanceof Polygon) {
            return (Polygon)val;
        }
        return null;
    }

    public Circle getCircle(int pos) {
        Object val = this.get(pos);
        if (val instanceof Circle) {
            return (Circle)val;
        }
        return null;
    }

    public Interval getInterval(int pos) {
        Object val = this.get(pos);
        if (val instanceof Interval) {
            return (Interval)val;
        }
        return null;
    }

    public Character[] getCharArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Character[]) {
            return (Character[])val;
        }
        return null;
    }

    public Object[] getJsonArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Object[]) {
            return (Object[])val;
        }
        return null;
    }

    public Numeric[] getNumericArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Numeric[]) {
            return (Numeric[])val;
        }
        return null;
    }

    public Point[] getPointArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Point[]) {
            return (Point[])val;
        }
        return null;
    }

    public Line[] getLineArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Line[]) {
            return (Line[])val;
        }
        return null;
    }

    public LineSegment[] getLineSegmentArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof LineSegment[]) {
            return (LineSegment[])val;
        }
        return null;
    }

    public Box[] getBoxArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Box[]) {
            return (Box[])val;
        }
        return null;
    }

    public Path[] getPathArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Path[]) {
            return (Path[])val;
        }
        return null;
    }

    public Polygon[] getPolygonArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Polygon[]) {
            return (Polygon[])val;
        }
        return null;
    }

    public Circle[] getCircleArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Circle[]) {
            return (Circle[])val;
        }
        return null;
    }

    public Interval[] getIntervalArray(int pos) {
        Object val = this.get(pos);
        if (val instanceof Interval[]) {
            return (Interval[])val;
        }
        return null;
    }
}

