/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.pgclient.impl.util.Util;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.Arrays;
import java.util.stream.Stream;

class PgParamDesc
extends ParamDesc {
    private final DataType[] paramDataTypes;

    PgParamDesc(DataType[] paramDataTypes) {
        this.paramDataTypes = paramDataTypes;
    }

    DataType[] paramDataTypes() {
        return this.paramDataTypes;
    }

    public String prepare(TupleInternal values) {
        if (values.size() != this.paramDataTypes.length) {
            return this.buildReport((Tuple)values);
        }
        for (int i = 0; i < this.paramDataTypes.length; ++i) {
            DataType paramDataType = this.paramDataTypes[i];
            Object value = values.getValue(i);
            Object val = DataTypeCodec.prepare(paramDataType, value);
            if (val == value) continue;
            if (val == DataTypeCodec.REFUSED_SENTINEL) {
                return this.buildReport((Tuple)values);
            }
            values.setValue(i, val);
        }
        return null;
    }

    private String buildReport(Tuple values) {
        return Util.buildInvalidArgsError(values, Stream.of(this.paramDataTypes).map(type -> type.decodingType));
    }

    public String toString() {
        return "PgParamDesc{paramDataTypes=" + Arrays.toString((Object[])this.paramDataTypes) + '}';
    }
}

