/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.AsyncResult;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.impl.PgPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.RowSet;
import io.vertx.sqlclient.SqlResult;
import io.vertx.sqlclient.Tuple;
import java.util.List;
import java.util.stream.Collector;

@VertxGen
public interface PgPool
extends Pool {
    public static PgPool pool() {
        return PgPool.pool(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static PgPool pool(PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(String connectionUri) {
        return PgPool.pool(connectionUri, new PoolOptions());
    }

    public static PgPool pool(String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static PgPool pool(Vertx vertx, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(PgConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use PgPool#pool(Vertx, PgConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        if (connectOptions.isUsingDomainSocket()) {
            vertxOptions.setPreferNativeTransport(true);
        }
        Vertx vertx = Vertx.vertx((VertxOptions)vertxOptions);
        return new PgPoolImpl(vertx.getOrCreateContext(), true, connectOptions, poolOptions);
    }

    public static PgPool pool(Vertx vertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return new PgPoolImpl(vertx.getOrCreateContext(), false, connectOptions, poolOptions);
    }

    public PgPool preparedQuery(String var1, Handler<AsyncResult<RowSet<Row>>> var2);

    @GenIgnore
    public <R> PgPool preparedQuery(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public PgPool query(String var1, Handler<AsyncResult<RowSet<Row>>> var2);

    @GenIgnore
    public <R> PgPool query(String var1, Collector<Row, ?, R> var2, Handler<AsyncResult<SqlResult<R>>> var3);

    public PgPool preparedQuery(String var1, Tuple var2, Handler<AsyncResult<RowSet<Row>>> var3);

    @GenIgnore
    public <R> PgPool preparedQuery(String var1, Tuple var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);

    public PgPool preparedBatch(String var1, List<Tuple> var2, Handler<AsyncResult<RowSet<Row>>> var3);

    @GenIgnore
    public <R> PgPool preparedBatch(String var1, List<Tuple> var2, Collector<Row, ?, R> var3, Handler<AsyncResult<SqlResult<R>>> var4);
}

