/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.PathConverter;
import io.vertx.pgclient.data.Point;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class Path {
    private boolean isOpen;
    private List<Point> points;

    public Path() {
        this(false, new ArrayList<Point>());
    }

    public Path(boolean isOpen, List<Point> points) {
        this.isOpen = isOpen;
        this.points = points;
    }

    public Path(JsonObject json) {
        PathConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public boolean isOpen() {
        return this.isOpen;
    }

    public void setOpen(boolean open) {
        this.isOpen = open;
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Path path = (Path)o;
        if (this.isOpen != path.isOpen) {
            return false;
        }
        return this.points.equals(path.points);
    }

    public int hashCode() {
        int result = this.isOpen ? 1 : 0;
        result = 31 * result + this.points.hashCode();
        return result;
    }

    public String toString() {
        String right;
        String left;
        if (this.isOpen) {
            left = "[";
            right = "]";
        } else {
            left = "(";
            right = ")";
        }
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Path");
        stringBuilder.append(left);
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = this.points.get(i);
            stringBuilder.append(point.toString());
            if (i == this.points.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(right);
        return stringBuilder.toString();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PathConverter.toJson(this, json);
        return json;
    }
}

