/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.PasswordMessage;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.ScramClientFinalMessage;
import io.vertx.pgclient.impl.codec.StartupMessage;
import io.vertx.pgclient.impl.util.ScramAuthentication;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.TxStatus;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.InitCommand;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;

class InitCommandCodec
extends PgCommandCodec<Connection, InitCommand> {
    private PgEncoder encoder;
    private String encoding;
    private ScramAuthentication scramAuthentication;

    InitCommandCodec(InitCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(PgEncoder encoder) {
        this.encoder = encoder;
        encoder.writeStartupMessage(new StartupMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).database(), ((InitCommand)this.cmd).properties()));
    }

    @Override
    public void handleAuthenticationMD5Password(byte[] salt) {
        this.encoder.writePasswordMessage(new PasswordMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password(), salt));
        this.encoder.flush();
    }

    @Override
    public void handleAuthenticationClearTextPassword() {
        this.encoder.writePasswordMessage(new PasswordMessage(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password(), null));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSasl(ByteBuf in) {
        this.scramAuthentication = new ScramAuthentication(((InitCommand)this.cmd).username(), ((InitCommand)this.cmd).password());
        this.encoder.writeScramClientInitialMessage(this.scramAuthentication.createInitialSaslMessage(in));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSaslContinue(ByteBuf in) {
        this.encoder.writeScramClientFinalMessage(new ScramClientFinalMessage(this.scramAuthentication.receiveServerFirstMessage(in)));
        this.encoder.flush();
    }

    @Override
    void handleAuthenticationSaslFinal(ByteBuf in) {
        this.scramAuthentication.checkServerFinalMessage(in);
    }

    @Override
    public void handleAuthenticationOk() {
    }

    @Override
    public void handleParameterStatus(String key, String value) {
        if (key.equals("client_encoding")) {
            this.encoding = value;
        }
    }

    @Override
    public void handleBackendKeyData(int processId, int secretKey) {
        ((PgSocketConnection)((InitCommand)this.cmd).connection()).processId = processId;
        ((PgSocketConnection)((InitCommand)this.cmd).connection()).secretKey = secretKey;
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        CommandResponse resp = CommandResponse.failure((Throwable)errorResponse.toException());
        this.completionHandler.handle((Object)resp);
    }

    @Override
    public void handleReadyForQuery(TxStatus txStatus) {
        Charset cs = null;
        try {
            cs = Charset.forName(this.encoding);
        }
        catch (Exception exception) {
            // empty catch block
        }
        CommandResponse fut = cs == null || !cs.equals(StandardCharsets.UTF_8) ? CommandResponse.failure((String)(this.encoding + " is not supported in the client only UTF8")) : CommandResponse.success((Object)((InitCommand)this.cmd).connection());
        this.completionHandler.handle((Object)fut);
    }
}

