/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.LineConverter;
import java.util.Map;

@DataObject(generateConverter=true)
public class Line {
    private double a;
    private double b;
    private double c;

    public Line() {
        this(0.0, 0.0, 0.0);
    }

    public Line(double a, double b, double c) {
        this.a = a;
        this.b = b;
        this.c = c;
    }

    public Line(JsonObject json) {
        LineConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public double getA() {
        return this.a;
    }

    public void setA(double a) {
        this.a = a;
    }

    public double getB() {
        return this.b;
    }

    public void setB(double b) {
        this.b = b;
    }

    public double getC() {
        return this.c;
    }

    public void setC(double c) {
        this.c = c;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Line that = (Line)o;
        if (this.a != that.a) {
            return false;
        }
        if (this.b != that.b) {
            return false;
        }
        return this.c == that.c;
    }

    public int hashCode() {
        long temp = Double.doubleToLongBits(this.a);
        int result = (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.b);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        temp = Double.doubleToLongBits(this.c);
        result = 31 * result + (int)(temp ^ temp >>> 32);
        return result;
    }

    public String toString() {
        return "Line{" + this.a + "," + this.b + "," + this.c + "}";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        LineConverter.toJson(this, json);
        return json;
    }
}

