/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.PolygonConverter;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;

@DataObject(generateConverter=true)
public class Polygon {
    private List<Point> points;

    public Polygon() {
        this(new ArrayList<Point>());
    }

    public Polygon(List<Point> points) {
        this.points = points;
    }

    public Polygon(JsonObject json) {
        PolygonConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public List<Point> getPoints() {
        return this.points;
    }

    public void setPoints(List<Point> points) {
        this.points = points;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Polygon polygon = (Polygon)o;
        return this.points.equals(polygon.points);
    }

    public int hashCode() {
        return this.points.hashCode();
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("Polygon");
        stringBuilder.append("(");
        for (int i = 0; i < this.points.size(); ++i) {
            Point point = this.points.get(i);
            stringBuilder.append(point.toString());
            if (i == this.points.size() - 1) continue;
            stringBuilder.append(",");
        }
        stringBuilder.append(")");
        return stringBuilder.toString();
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        PolygonConverter.toJson(this, json);
        return json;
    }
}

