/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;

public class PgPoolImpl
extends PoolBase<PgPoolImpl>
implements PgPool {
    private final PgConnectionFactory factory;

    public PgPoolImpl(Context context, boolean closeVertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        super(context, closeVertx, poolOptions);
        this.factory = new PgConnectionFactory(context, Vertx.currentContext() != null, connectOptions);
    }

    public void connect(Handler<AsyncResult<Connection>> completionHandler) {
        this.factory.connectAndInit(completionHandler);
    }

    protected SqlConnectionImpl wrap(Context context, Connection conn) {
        return new PgConnectionImpl(this.factory, context, conn);
    }

    protected void doClose() {
        this.factory.close();
        super.doClose();
    }
}

