/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgPreparedStatement;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.pgclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.pgclient.impl.codec.RowResultDecoder;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.codec.InvalidCachedStatementEvent;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommandBase;

abstract class ExtendedQueryCommandBaseCodec<R, C extends ExtendedQueryCommandBase<R>>
extends QueryCommandBaseCodec<R, C> {
    private PgEncoder encoder;
    private static final String TABLE_SCHEMA_CHANGE_ERROR_MESSAGE_PATTERN = "bind message has \\d result formats but query has \\d columns";

    ExtendedQueryCommandBaseCodec(C cmd) {
        super(cmd);
        this.decoder = new RowResultDecoder(cmd.collector(), ((PgPreparedStatement)cmd.preparedStatement()).rowDesc());
    }

    @Override
    void encode(PgEncoder encoder) {
        this.encoder = encoder;
    }

    @Override
    void handleRowDescription(PgRowDesc rowDescription) {
        this.decoder = new RowResultDecoder(((ExtendedQueryCommandBase)this.cmd).collector(), rowDescription);
    }

    @Override
    void handleParseComplete() {
    }

    @Override
    void handlePortalSuspended() {
        Throwable failure = this.decoder.complete();
        Object result = this.decoder.result();
        PgRowDesc desc = this.decoder.desc;
        int size = this.decoder.size();
        this.decoder.reset();
        this.result = true;
        ((ExtendedQueryCommandBase)this.cmd).resultHandler().handleResult(0, size, (RowDesc)desc, result, failure);
    }

    @Override
    void handleBindComplete() {
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        if (((ExtendedQueryCommandBase)this.cmd).preparedStatement().cacheable() && errorResponse.getMessage().matches(TABLE_SCHEMA_CHANGE_ERROR_MESSAGE_PATTERN)) {
            this.encoder.channelHandlerContext().fireChannelRead((Object)new InvalidCachedStatementEvent(((ExtendedQueryCommandBase)this.cmd).preparedStatement().sql()));
        }
        super.handleErrorResponse(errorResponse);
    }
}

