/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.Describe;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.Parse;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.pgclient.impl.codec.PgPreparedStatement;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.sqlclient.impl.PreparedStatement;
import io.vertx.sqlclient.impl.command.PrepareStatementCommand;

class PrepareStatementCommandCodec
extends PgCommandCodec<PreparedStatement, PrepareStatementCommand> {
    private PgParamDesc parameterDesc;
    private PgRowDesc rowDesc;
    private long statement;

    PrepareStatementCommandCodec(PrepareStatementCommand cmd) {
        super(cmd);
    }

    @Override
    void encode(PgEncoder encoder) {
        this.statement = !((PrepareStatementCommand)this.cmd).cacheable() ? encoder.nextStatementName() : 0L;
        encoder.writeParse(new Parse(((PrepareStatementCommand)this.cmd).sql(), this.statement));
        encoder.writeDescribe(new Describe(this.statement, null));
        encoder.writeSync();
    }

    @Override
    public void handleParseComplete() {
    }

    @Override
    public void handleParameterDescription(PgParamDesc paramDesc) {
        this.parameterDesc = paramDesc;
    }

    @Override
    public void handleRowDescription(PgRowDesc rowDesc) {
        this.rowDesc = rowDesc;
    }

    @Override
    public void handleNoData() {
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        this.failure = errorResponse.toException();
    }

    @Override
    public void handleReadyForQuery() {
        this.result = new PgPreparedStatement(((PrepareStatementCommand)this.cmd).sql(), this.statement, this.parameterDesc, this.rowDesc, ((PrepareStatementCommand)this.cmd).cacheable());
        super.handleReadyForQuery();
    }
}

