/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.BoxConverter;
import io.vertx.pgclient.data.Point;
import java.util.Map;

@DataObject(generateConverter=true)
public class Box {
    private Point upperRightCorner;
    private Point lowerLeftCorner;

    public Box() {
        this(new Point(), new Point());
    }

    public Box(Point upperRightCorner, Point lowerLeftCorner) {
        this.upperRightCorner = upperRightCorner;
        this.lowerLeftCorner = lowerLeftCorner;
    }

    public Box(JsonObject json) {
        BoxConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public Point getUpperRightCorner() {
        return this.upperRightCorner;
    }

    public void setUpperRightCorner(Point upperRightCorner) {
        this.upperRightCorner = upperRightCorner;
    }

    public Point getLowerLeftCorner() {
        return this.lowerLeftCorner;
    }

    public void setLowerLeftCorner(Point lowerLeftCorner) {
        this.lowerLeftCorner = lowerLeftCorner;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Box box = (Box)o;
        if (!this.upperRightCorner.equals(box.upperRightCorner)) {
            return false;
        }
        return this.lowerLeftCorner.equals(box.lowerLeftCorner);
    }

    public int hashCode() {
        int result = this.upperRightCorner.hashCode();
        result = 31 * result + this.lowerLeftCorner.hashCode();
        return result;
    }

    public String toString() {
        return "Box(" + this.upperRightCorner.toString() + "," + this.lowerLeftCorner.toString() + ")";
    }

    public JsonObject toJson() {
        JsonObject json = new JsonObject();
        BoxConverter.toJson(this, json);
        return json;
    }
}

