/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Closeable;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.Vertx;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.HashMap;
import java.util.Map;
import java.util.function.Predicate;

class PgConnectionFactory {
    private final NetClient client;
    private final Context ctx;
    private final boolean registerCloseHook;
    private final String host;
    private final int port;
    private final SslMode sslMode;
    private final TrustOptions trustOptions;
    private final String hostnameVerificationAlgorithm;
    private final String database;
    private final String username;
    private final String password;
    private final Map<String, String> properties;
    private final boolean cachePreparedStatements;
    private final int preparedStatementCacheSize;
    private final Predicate<String> preparedStatementCacheSqlFilter;
    private final int pipeliningLimit;
    private final boolean isUsingDomainSocket;
    private final Closeable hook = this::close;

    PgConnectionFactory(Context context, boolean registerCloseHook, PgConnectOptions options) {
        this.registerCloseHook = registerCloseHook;
        this.ctx = context;
        if (registerCloseHook) {
            this.ctx.addCloseHook(this.hook);
        }
        NetClientOptions netClientOptions = new NetClientOptions((NetClientOptions)options);
        netClientOptions.setSsl(false);
        this.sslMode = options.getSslMode();
        this.hostnameVerificationAlgorithm = netClientOptions.getHostnameVerificationAlgorithm();
        this.trustOptions = netClientOptions.getTrustOptions();
        this.host = options.getHost();
        this.port = options.getPort();
        this.database = options.getDatabase();
        this.username = options.getUser();
        this.password = options.getPassword();
        this.properties = new HashMap<String, String>(options.getProperties());
        this.cachePreparedStatements = options.getCachePreparedStatements();
        this.pipeliningLimit = options.getPipeliningLimit();
        this.preparedStatementCacheSize = options.getPreparedStatementCacheMaxSize();
        this.preparedStatementCacheSqlFilter = options.getPreparedStatementCacheSqlFilter();
        this.isUsingDomainSocket = options.isUsingDomainSocket();
        this.client = context.owner().createNetClient(netClientOptions);
    }

    private void close(Handler<AsyncResult<Void>> completionHandler) {
        this.client.close();
        completionHandler.handle((Object)Future.succeededFuture());
    }

    void close() {
        if (this.registerCloseHook) {
            this.ctx.removeCloseHook(this.hook);
        }
        this.client.close();
    }

    void connectAndInit(Handler<AsyncResult<Connection>> completionHandler) {
        this.connect((Handler<AsyncResult<PgSocketConnection>>)((Handler)ar -> {
            if (ar.succeeded()) {
                PgSocketConnection conn = (PgSocketConnection)((Object)((Object)ar.result()));
                conn.init();
                conn.sendStartupMessage(this.username, this.password, this.database, this.properties, (Handler<? super CommandResponse<Connection>>)completionHandler);
            } else {
                completionHandler.handle((Object)CommandResponse.failure((Throwable)ar.cause()));
            }
        }));
    }

    void connect(Handler<AsyncResult<PgSocketConnection>> handler) {
        switch (this.sslMode) {
            case DISABLE: {
                this.doConnect(false, handler);
                break;
            }
            case ALLOW: {
                this.doConnect(false, (Handler<AsyncResult<PgSocketConnection>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                    } else {
                        this.doConnect(true, handler);
                    }
                }));
                break;
            }
            case PREFER: {
                this.doConnect(true, (Handler<AsyncResult<PgSocketConnection>>)((Handler)ar -> {
                    if (ar.succeeded()) {
                        handler.handle((Object)Future.succeededFuture((Object)ar.result()));
                    } else {
                        this.doConnect(false, handler);
                    }
                }));
                break;
            }
            case VERIFY_FULL: {
                if (this.hostnameVerificationAlgorithm == null || this.hostnameVerificationAlgorithm.isEmpty()) {
                    handler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode")));
                    return;
                }
            }
            case VERIFY_CA: {
                if (this.trustOptions == null) {
                    handler.handle((Object)Future.failedFuture((Throwable)new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode")));
                    return;
                }
            }
            case REQUIRE: {
                this.doConnect(true, handler);
                break;
            }
            default: {
                throw new IllegalArgumentException("Unsupported SSL mode");
            }
        }
    }

    private void doConnect(boolean ssl, Handler<AsyncResult<PgSocketConnection>> handler) {
        if (Vertx.currentContext() != this.ctx) {
            throw new IllegalStateException();
        }
        SocketAddress socketAddress = !this.isUsingDomainSocket ? SocketAddress.inetSocketAddress((int)this.port, (String)this.host) : SocketAddress.domainSocketAddress((String)(this.host + "/.s.PGSQL." + this.port));
        Promise promise = Promise.promise();
        promise.future().setHandler(ar -> {
            if (ar.succeeded()) {
                NetSocketInternal socket = (NetSocketInternal)ar.result();
                PgSocketConnection conn = this.newSocketConnection(socket);
                if (ssl && !this.isUsingDomainSocket) {
                    conn.upgradeToSSLConnection((Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                        if (ar2.succeeded()) {
                            handler.handle((Object)Future.succeededFuture((Object)((Object)conn)));
                        } else {
                            handler.handle((Object)Future.failedFuture((Throwable)ar2.cause()));
                        }
                    }));
                } else {
                    handler.handle((Object)Future.succeededFuture((Object)((Object)conn)));
                }
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
        try {
            this.client.connect(socketAddress, null, (Handler)promise);
        }
        catch (Exception e) {
            promise.fail((Throwable)e);
        }
    }

    private PgSocketConnection newSocketConnection(NetSocketInternal socket) {
        return new PgSocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, this.ctx);
    }
}

