/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.DataTypeCodec;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.Arrays;

class PgParamDesc
extends ParamDesc {
    private final DataType[] paramDataTypes;

    PgParamDesc(DataType[] paramDataTypes) {
        this.paramDataTypes = paramDataTypes;
    }

    DataType[] paramDataTypes() {
        return this.paramDataTypes;
    }

    public String prepare(TupleInternal values) {
        int paramDescLength;
        int numberOfParams = values.size();
        if (numberOfParams != (paramDescLength = this.paramDataTypes.length)) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParams);
        }
        for (int i = 0; i < paramDescLength; ++i) {
            DataType paramDataType = this.paramDataTypes[i];
            Object value = values.getValue(i);
            Object val = DataTypeCodec.prepare(paramDataType, value);
            if (val == value) continue;
            if (val == DataTypeCodec.REFUSED_SENTINEL) {
                return ErrorMessageFactory.buildWhenArgumentsTypeNotMatched(paramDataType.decodingType, (int)i, (Object)value);
            }
            values.setValue(i, val);
        }
        return null;
    }

    public String toString() {
        return "PgParamDesc{paramDataTypes=" + Arrays.toString((Object[])this.paramDataTypes) + '}';
    }
}

