/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelPipeline;
import io.netty.handler.codec.DecoderException;
import io.vertx.core.AsyncResult;
import io.vertx.core.Context;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.impl.NetSocketInternal;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.impl.InitiateSslHandler;
import io.vertx.pgclient.impl.PgDatabaseMetadata;
import io.vertx.pgclient.impl.codec.PgCodec;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.SocketConnectionBase;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.InitCommand;
import io.vertx.sqlclient.spi.DatabaseMetadata;
import java.util.Map;
import java.util.function.Predicate;

public class PgSocketConnection
extends SocketConnectionBase {
    private PgCodec codec;
    public int processId;
    public int secretKey;
    public PgDatabaseMetadata dbMetaData;

    public PgSocketConnection(NetSocketInternal socket, boolean cachePreparedStatements, int preparedStatementCacheSize, Predicate<String> preparedStatementCacheSqlFilter, int pipeliningLimit, Context context) {
        super(socket, cachePreparedStatements, preparedStatementCacheSize, preparedStatementCacheSqlFilter, pipeliningLimit, context);
    }

    public void init() {
        this.codec = new PgCodec();
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        pipeline.addBefore("handler", "codec", (ChannelHandler)this.codec);
        super.init();
    }

    public void sendStartupMessage(String username, String password, String database, Map<String, String> properties, Handler<? super CommandResponse<Connection>> completionHandler) {
        InitCommand cmd = new InitCommand((SocketConnectionBase)this, username, password, database, properties);
        cmd.handler = completionHandler;
        this.schedule((CommandBase)cmd);
    }

    void sendCancelRequestMessage(int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        Buffer buffer = Buffer.buffer((int)16);
        buffer.appendInt(16);
        buffer.appendInt(80877102);
        buffer.appendInt(processId);
        buffer.appendInt(secretKey);
        this.socket.write(buffer, ar -> {
            if (ar.succeeded()) {
                if (this.status == SocketConnectionBase.Status.CONNECTED) {
                    this.status = SocketConnectionBase.Status.CLOSING;
                    this.socket.close();
                }
                handler.handle((Object)Future.succeededFuture());
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    public int getProcessId() {
        return this.processId;
    }

    public int getSecretKey() {
        return this.secretKey;
    }

    public DatabaseMetadata getDatabaseMetaData() {
        return this.dbMetaData;
    }

    void upgradeToSSLConnection(Handler<AsyncResult<Void>> completionHandler) {
        ChannelPipeline pipeline = this.socket.channelHandlerContext().pipeline();
        Promise upgradePromise = Promise.promise();
        upgradePromise.future().setHandler(ar -> {
            if (ar.succeeded()) {
                completionHandler.handle((Object)Future.succeededFuture());
            } else {
                Throwable cause = ar.cause();
                if (cause instanceof DecoderException) {
                    DecoderException err = (DecoderException)cause;
                    cause = err.getCause();
                }
                completionHandler.handle((Object)Future.failedFuture((Throwable)cause));
            }
        });
        pipeline.addBefore("handler", "initiate-ssl-handler", (ChannelHandler)new InitiateSslHandler(this, (Promise<Void>)upgradePromise));
    }

    public boolean isIndeterminatePreparedStatementError(Throwable t) {
        if (t instanceof PgException) {
            PgException e = (PgException)t;
            return "42P18".equals(e.getCode());
        }
        return false;
    }
}

