/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.Row;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.ArrayTuple;
import io.vertx.sqlclient.impl.RowDesc;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.UUID;

public class RowImpl
extends ArrayTuple
implements Row {
    private final RowDesc desc;

    public RowImpl(RowDesc desc) {
        super(desc.columnNames().size());
        this.desc = desc;
    }

    public RowImpl(RowImpl row) {
        super((Tuple)row);
        this.desc = row.desc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.desc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.desc.columnNames().indexOf(name);
    }

    public <T> T get(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return type.cast(this.getBoolean(pos));
        }
        if (type == Short.class) {
            return type.cast(this.getShort(pos));
        }
        if (type == Integer.class) {
            return type.cast(this.getInteger(pos));
        }
        if (type == Long.class) {
            return type.cast(this.getLong(pos));
        }
        if (type == Float.class) {
            return type.cast(this.getFloat(pos));
        }
        if (type == Double.class) {
            return type.cast(this.getDouble(pos));
        }
        if (type == Character.class) {
            return type.cast(this.getChar(pos));
        }
        if (type == Numeric.class) {
            return type.cast(this.getNumeric(pos));
        }
        if (type == String.class) {
            return type.cast(this.getString(pos));
        }
        if (type == Buffer.class) {
            return type.cast(this.getBuffer(pos));
        }
        if (type == UUID.class) {
            return type.cast(this.getUUID(pos));
        }
        if (type == LocalDate.class) {
            return type.cast(this.getLocalDate(pos));
        }
        if (type == LocalTime.class) {
            return type.cast(this.getLocalTime(pos));
        }
        if (type == OffsetTime.class) {
            return type.cast(this.getOffsetTime(pos));
        }
        if (type == LocalDateTime.class) {
            return type.cast(this.getLocalDateTime(pos));
        }
        if (type == OffsetDateTime.class) {
            return type.cast(this.getOffsetDateTime(pos));
        }
        if (type == Interval.class) {
            return type.cast(this.getInterval(pos));
        }
        if (type == Point.class) {
            return type.cast(this.getPoint(pos));
        }
        if (type == Line.class) {
            return type.cast(this.getLine(pos));
        }
        if (type == LineSegment.class) {
            return type.cast(this.getLineSegment(pos));
        }
        if (type == Path.class) {
            return type.cast(this.getPath(pos));
        }
        if (type == Polygon.class) {
            return type.cast(this.getPolygon(pos));
        }
        if (type == Circle.class) {
            return type.cast(this.getCircle(pos));
        }
        if (type == Box.class) {
            return type.cast(this.getBox(pos));
        }
        if (type == JsonObject.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == JsonArray.class) {
            return type.cast(this.getJson(pos));
        }
        if (type == Object.class) {
            return type.cast(this.getValue(pos));
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public <T> T[] getValues(Class<T> type, int pos) {
        if (type == Boolean.class) {
            return this.getBooleanArray(pos);
        }
        if (type == Short.class) {
            return this.getShortArray(pos);
        }
        if (type == Integer.class) {
            return this.getIntegerArray(pos);
        }
        if (type == Long.class) {
            return this.getLongArray(pos);
        }
        if (type == Float.class) {
            return this.getFloatArray(pos);
        }
        if (type == Double.class) {
            return this.getDoubleArray(pos);
        }
        if (type == Character.class) {
            return this.getCharArray(pos);
        }
        if (type == String.class) {
            return this.getStringArray(pos);
        }
        if (type == Buffer.class) {
            return this.getBufferArray(pos);
        }
        if (type == UUID.class) {
            return this.getUUIDArray(pos);
        }
        if (type == LocalDate.class) {
            return this.getLocalDateArray(pos);
        }
        if (type == LocalTime.class) {
            return this.getLocalTimeArray(pos);
        }
        if (type == OffsetTime.class) {
            return this.getOffsetTimeArray(pos);
        }
        if (type == LocalDateTime.class) {
            return this.getLocalDateTimeArray(pos);
        }
        if (type == OffsetDateTime.class) {
            return this.getOffsetDateTimeArray(pos);
        }
        if (type == Interval.class) {
            return this.getIntervalArray(pos);
        }
        if (type == Numeric.class) {
            return this.getNumericArray(pos);
        }
        if (type == Point.class) {
            return this.getPointArray(pos);
        }
        if (type == Line.class) {
            return this.getLineArray(pos);
        }
        if (type == LineSegment.class) {
            return this.getLineSegmentArray(pos);
        }
        if (type == Path.class) {
            return this.getPathArray(pos);
        }
        if (type == Polygon.class) {
            return this.getPolygonArray(pos);
        }
        if (type == Circle.class) {
            return this.getCircleArray(pos);
        }
        if (type == Interval.class) {
            return this.getIntervalArray(pos);
        }
        if (type == Box.class) {
            return this.getBoxArray(pos);
        }
        if (type == Object.class) {
            return this.getJsonArray(pos);
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    public Point getPoint(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPoint(pos);
    }

    public Line getLine(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLine(pos);
    }

    public LineSegment getLineSegment(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineSegment(pos);
    }

    public Box getBox(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBox(pos);
    }

    public Path getPath(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPath(pos);
    }

    public Polygon getPolygon(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPolygon(pos);
    }

    public Circle getCircle(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCircle(pos);
    }

    public Interval getInterval(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getInterval(pos);
    }

    public Object[] getJsonArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getJsonArray(pos);
    }

    public Point[] getPointArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPointArray(pos);
    }

    public Line[] getLineArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineArray(pos);
    }

    public LineSegment[] getLineSegmentArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getLineSegmentArray(pos);
    }

    public Box[] getBoxArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getBoxArray(pos);
    }

    public Path[] getPathArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPathArray(pos);
    }

    public Polygon[] getPolygonArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getPolygonArray(pos);
    }

    public Circle[] getCircleArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCircleArray(pos);
    }

    public Interval[] getIntervalArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getIntervalArray(pos);
    }

    public Character[] getCharArray(String name) {
        int pos = this.desc.columnIndex(name);
        return pos == -1 ? null : this.getCharArray(pos);
    }

    public Character getChar(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof Character) {
            return (Character)val;
        }
        return null;
    }

    public Object getJson(int pos) {
        Object val = this.getValue(pos);
        if (val instanceof JsonObject) {
            return val;
        }
        if (val instanceof JsonArray) {
            return val;
        }
        throw new ClassCastException();
    }

    private Point getPoint(int pos) {
        return (Point)this.getValue(pos);
    }

    private Line getLine(int pos) {
        return (Line)this.getValue(pos);
    }

    private LineSegment getLineSegment(int pos) {
        return (LineSegment)this.getValue(pos);
    }

    private Box getBox(int pos) {
        return (Box)this.getValue(pos);
    }

    private Path getPath(int pos) {
        return (Path)this.getValue(pos);
    }

    private Polygon getPolygon(int pos) {
        return (Polygon)this.getValue(pos);
    }

    private Circle getCircle(int pos) {
        return (Circle)this.getValue(pos);
    }

    private Interval getInterval(int pos) {
        return (Interval)this.getValue(pos);
    }

    public Character[] getCharArray(int pos) {
        return (Character[])this.getValue(pos);
    }

    private Object[] getJsonArray(int pos) {
        return (Object[])this.getValue(pos);
    }

    private Point[] getPointArray(int pos) {
        return (Point[])this.getValue(pos);
    }

    private Line[] getLineArray(int pos) {
        return (Line[])this.getValue(pos);
    }

    private LineSegment[] getLineSegmentArray(int pos) {
        return (LineSegment[])this.getValue(pos);
    }

    private Box[] getBoxArray(int pos) {
        return (Box[])this.getValue(pos);
    }

    private Path[] getPathArray(int pos) {
        return (Path[])this.getValue(pos);
    }

    private Polygon[] getPolygonArray(int pos) {
        return (Polygon[])this.getValue(pos);
    }

    private Circle[] getCircleArray(int pos) {
        return (Circle[])this.getValue(pos);
    }

    private Interval[] getIntervalArray(int pos) {
        return (Interval[])this.getValue(pos);
    }
}

