/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.VertxInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.impl.PgPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;

@VertxGen
public interface PgPool
extends Pool {
    public static PgPool pool() {
        return PgPool.pool(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static PgPool pool(PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(String connectionUri) {
        return PgPool.pool(connectionUri, new PoolOptions());
    }

    public static PgPool pool(String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static PgPool pool(Vertx vertx, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(PgConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use PgPool#pool(Vertx, PgConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        if (connectOptions.isUsingDomainSocket()) {
            vertxOptions.setPreferNativeTransport(true);
        }
        VertxInternal vertx = (VertxInternal)Vertx.vertx((VertxOptions)vertxOptions);
        return PgPoolImpl.create(vertx.getOrCreateContext(), true, connectOptions, poolOptions);
    }

    public static PgPool pool(Vertx vertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return PgPoolImpl.create(((VertxInternal)vertx).getOrCreateContext(), false, connectOptions, poolOptions);
    }
}

