/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class PgPoolImpl
extends PoolBase<PgPoolImpl>
implements PgPool {
    private final PgConnectionFactory factory;

    public static PgPoolImpl create(ContextInternal context, boolean closeVertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = context.tracer() == null ? null : new QueryTracer(context.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = context.owner().metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        EventLoopContext eventLoopContext = ConnectionFactory.asEventLoopContext((ContextInternal)context);
        PgPoolImpl pool = new PgPoolImpl(eventLoopContext, new PgConnectionFactory(eventLoopContext, connectOptions), tracer, metrics, poolOptions);
        CloseFuture closeFuture = pool.closeFuture();
        if (closeVertx) {
            closeFuture.onComplete(ar -> context.owner().close());
        } else {
            context.addCloseHook((Closeable)closeFuture);
        }
        return pool;
    }

    private PgPoolImpl(EventLoopContext context, PgConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, PoolOptions poolOptions) {
        super(context, (ConnectionFactory)factory, tracer, metrics, poolOptions);
        this.factory = factory;
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('$').append(1 + index);
        return index;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new PgConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

