/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.ParamExtractor;
import io.vertx.sqlclient.impl.ErrorMessageFactory;
import io.vertx.sqlclient.impl.ParamDesc;
import io.vertx.sqlclient.impl.TupleInternal;
import java.util.Arrays;

class PgParamDesc
extends ParamDesc {
    private final DataType[] paramDataTypes;

    PgParamDesc(DataType[] paramDataTypes) {
        this.paramDataTypes = paramDataTypes;
    }

    DataType[] paramDataTypes() {
        return this.paramDataTypes;
    }

    public String prepare(TupleInternal values) {
        int paramDescLength;
        int numberOfParams = values.size();
        if (numberOfParams != (paramDescLength = this.paramDataTypes.length)) {
            return ErrorMessageFactory.buildWhenArgumentsLengthNotMatched((int)paramDescLength, (int)numberOfParams);
        }
        for (int i = 0; i < paramDescLength; ++i) {
            Object val;
            DataType paramDataType = this.paramDataTypes[i];
            ParamExtractor<?> extractor = paramDataType.paramExtractor;
            try {
                val = extractor != null ? extractor.get(values, i) : values.get(paramDataType.encodingType, i);
            }
            catch (ClassCastException e) {
                return ErrorMessageFactory.buildWhenArgumentsTypeNotMatched(paramDataType.decodingType, (int)i, (Object)values.getValue(i));
            }
            values.setValue(i, val);
        }
        return null;
    }

    public String toString() {
        return "PgParamDesc{paramDataTypes=" + Arrays.toString((Object[])this.paramDataTypes) + '}';
    }
}

