/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.spi;

import io.vertx.core.Vertx;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.spi.Driver;

public class PgDriver
implements Driver {
    public Pool createPool(SqlConnectOptions options, PoolOptions poolOptions) {
        return PgPool.pool(PgDriver.wrap(options), poolOptions);
    }

    public Pool createPool(Vertx vertx, SqlConnectOptions options, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgDriver.wrap(options), poolOptions);
    }

    public boolean acceptsOptions(SqlConnectOptions options) {
        return options instanceof PgConnectOptions || SqlConnectOptions.class.equals(options.getClass());
    }

    private static PgConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof PgConnectOptions) {
            return (PgConnectOptions)options;
        }
        return new PgConnectOptions(options);
    }
}

