/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.VertxGen;
import io.vertx.core.Vertx;
import io.vertx.core.impl.VertxInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.impl.PgPoolImpl;
import io.vertx.sqlclient.Pool;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlClient;

@VertxGen
public interface PgPool
extends Pool {
    public static PgPool pool() {
        return PgPool.pool(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static PgPool pool(PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(String connectionUri) {
        return PgPool.pool(connectionUri, new PoolOptions());
    }

    public static PgPool pool(String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static PgPool pool(Vertx vertx, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromEnv(), poolOptions);
    }

    public static PgPool pool(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return PgPool.pool(vertx, PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static PgPool pool(PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return PgPoolImpl.create(false, connectOptions, poolOptions);
    }

    public static PgPool pool(Vertx vertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return PgPoolImpl.create((VertxInternal)vertx, false, false, connectOptions, poolOptions);
    }

    public static SqlClient client() {
        return PgPool.client(PgConnectOptions.fromEnv(), new PoolOptions());
    }

    public static SqlClient client(PoolOptions poolOptions) {
        return PgPool.client(PgConnectOptions.fromEnv(), poolOptions);
    }

    public static SqlClient client(String connectionUri) {
        return PgPool.client(connectionUri, new PoolOptions());
    }

    public static SqlClient client(String connectionUri, PoolOptions poolOptions) {
        return PgPool.client(PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(Vertx vertx, String connectionUri) {
        return PgPool.client(vertx, PgConnectOptions.fromUri(connectionUri), new PoolOptions());
    }

    public static SqlClient client(Vertx vertx, PoolOptions poolOptions) {
        return PgPool.client(vertx, PgConnectOptions.fromEnv(), poolOptions);
    }

    public static SqlClient client(Vertx vertx, String connectionUri, PoolOptions poolOptions) {
        return PgPool.client(vertx, PgConnectOptions.fromUri(connectionUri), poolOptions);
    }

    public static SqlClient client(PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return PgPoolImpl.create(true, connectOptions, poolOptions);
    }

    public static SqlClient client(Vertx vertx, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        return PgPoolImpl.create((VertxInternal)vertx, false, true, connectOptions, poolOptions);
    }
}

