/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.AsyncResult;
import io.vertx.core.Future;
import io.vertx.core.Handler;
import io.vertx.core.Promise;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.EventLoopContext;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.impl.future.PromiseInternal;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.net.impl.NetSocketInternal;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgSocketConnection;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.SqlConnectionFactoryBase;

class PgConnectionFactory
extends SqlConnectionFactoryBase
implements ConnectionFactory {
    private SslMode sslMode;
    private int pipeliningLimit;

    PgConnectionFactory(VertxInternal context, PgConnectOptions options) {
        super(context, (SqlConnectOptions)options);
    }

    protected void initializeConfiguration(SqlConnectOptions connectOptions) {
        PgConnectOptions options = (PgConnectOptions)connectOptions;
        this.pipeliningLimit = options.getPipeliningLimit();
        this.sslMode = options.isUsingDomainSocket() ? SslMode.DISABLE : options.getSslMode();
        switch (this.sslMode) {
            case VERIFY_FULL: {
                String hostnameVerificationAlgorithm = options.getHostnameVerificationAlgorithm();
                if (hostnameVerificationAlgorithm == null || hostnameVerificationAlgorithm.isEmpty()) {
                    throw new IllegalArgumentException("Host verification algorithm must be specified under verify-full sslmode");
                }
            }
            case VERIFY_CA: {
                TrustOptions trustOptions = options.getTrustOptions();
                if (trustOptions != null) break;
                throw new IllegalArgumentException("Trust options must be specified under verify-full or verify-ca sslmode");
            }
        }
    }

    protected void configureNetClientOptions(NetClientOptions netClientOptions) {
        netClientOptions.setSsl(false);
    }

    protected void doConnectInternal(Promise<Connection> promise) {
        PromiseInternal promiseInternal = (PromiseInternal)promise;
        this.doConnect(ConnectionFactory.asEventLoopContext((ContextInternal)promiseInternal.context())).flatMap(conn -> {
            PgSocketConnection socket = (PgSocketConnection)((Object)conn);
            socket.init();
            return Future.future(p -> socket.sendStartupMessage(this.username, this.password, this.database, this.properties, (Promise<Connection>)p)).map(conn);
        }).onComplete(promise);
    }

    public void cancelRequest(int processId, int secretKey, Handler<AsyncResult<Void>> handler) {
        this.doConnect(this.vertx.createEventLoopContext()).onComplete(ar -> {
            if (ar.succeeded()) {
                PgSocketConnection conn = (PgSocketConnection)((Object)((Object)ar.result()));
                conn.sendCancelRequestMessage(processId, secretKey, handler);
            } else {
                handler.handle((Object)Future.failedFuture((Throwable)ar.cause()));
            }
        });
    }

    private Future<Connection> doConnect(EventLoopContext context) {
        Future connFuture;
        switch (this.sslMode) {
            case DISABLE: {
                connFuture = this.doConnect(context, false);
                break;
            }
            case ALLOW: {
                connFuture = this.doConnect(context, false).recover(err -> this.doConnect(context, true));
                break;
            }
            case PREFER: {
                connFuture = this.doConnect(context, true).recover(err -> this.doConnect(context, false));
                break;
            }
            case VERIFY_FULL: 
            case VERIFY_CA: 
            case REQUIRE: {
                connFuture = this.doConnect(context, true);
                break;
            }
            default: {
                return context.failedFuture((Throwable)new IllegalArgumentException("Unsupported SSL mode"));
            }
        }
        return connFuture;
    }

    private Future<Connection> doConnect(EventLoopContext context, boolean ssl) {
        Future soFut;
        try {
            soFut = this.netClient.connect(this.socketAddress, (String)null);
        }
        catch (Exception e) {
            return context.failedFuture((Throwable)e);
        }
        Future connFut = soFut.map(so -> this.newSocketConnection(context, (NetSocketInternal)so));
        if (ssl && !this.socketAddress.isDomainSocket()) {
            connFut = connFut.flatMap(conn -> Future.future(p -> {
                PgSocketConnection socket = (PgSocketConnection)((Object)conn);
                socket.upgradeToSSLConnection((Handler<AsyncResult<Void>>)((Handler)ar2 -> {
                    if (ar2.succeeded()) {
                        p.complete(conn);
                    } else {
                        p.fail(ar2.cause());
                    }
                }));
            }));
        }
        return connFut;
    }

    private PgSocketConnection newSocketConnection(EventLoopContext context, NetSocketInternal socket) {
        return new PgSocketConnection(socket, this.cachePreparedStatements, this.preparedStatementCacheSize, this.preparedStatementCacheSqlFilter, this.pipeliningLimit, context);
    }
}

