/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.ConnectionFactory;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;

public class PgPoolImpl
extends PoolBase<PgPoolImpl>
implements PgPool {
    private final PgConnectionFactory factory;

    public static PgPoolImpl create(boolean pipelined, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        if (Vertx.currentContext() != null) {
            throw new IllegalStateException("Running in a Vertx context => use PgPool#pool(Vertx, PgConnectOptions, PoolOptions) instead");
        }
        VertxOptions vertxOptions = new VertxOptions();
        if (connectOptions.isUsingDomainSocket()) {
            vertxOptions.setPreferNativeTransport(true);
        }
        VertxInternal vertx = (VertxInternal)Vertx.vertx((VertxOptions)vertxOptions);
        return PgPoolImpl.create(vertx, true, pipelined, connectOptions, poolOptions);
    }

    public static PgPoolImpl create(VertxInternal vertx, boolean closeVertx, boolean pipelined, PgConnectOptions connectOptions, PoolOptions poolOptions) {
        QueryTracer tracer = vertx.tracer() == null ? null : new QueryTracer(vertx.tracer(), (SqlConnectOptions)connectOptions);
        VertxMetrics vertxMetrics = vertx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(connectOptions.getSocketAddress(), "sql", connectOptions.getMetricsName()) : null;
        int pipeliningLimit = pipelined ? connectOptions.getPipeliningLimit() : 1;
        PgPoolImpl pool = new PgPoolImpl(vertx, new PgConnectionFactory(vertx, connectOptions), tracer, metrics, pipeliningLimit, poolOptions);
        pool.init();
        CloseFuture closeFuture = pool.closeFuture();
        vertx.addCloseHook((Closeable)closeFuture);
        if (closeVertx) {
            closeFuture.future().onComplete(ar -> vertx.close());
        } else {
            ContextInternal ctx = vertx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vertx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private PgPoolImpl(VertxInternal vertx, PgConnectionFactory factory, QueryTracer tracer, ClientMetrics metrics, int pipeliningLimit, PoolOptions poolOptions) {
        super(vertx, (ConnectionFactory)factory, tracer, metrics, pipeliningLimit, poolOptions);
        this.factory = factory;
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('$').append(1 + index);
        return index;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, Connection conn) {
        return new PgConnectionImpl(this.factory, context, conn, this.tracer, this.metrics);
    }
}

