/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.ByteBufAllocator;
import io.netty.buffer.CompositeByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.util.ByteProcessor;
import io.vertx.pgclient.impl.codec.DataFormat;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgCommandCodec;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.pgclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.pgclient.impl.codec.Response;
import io.vertx.pgclient.impl.codec.TxFailedEvent;
import io.vertx.pgclient.impl.util.Util;
import io.vertx.sqlclient.impl.Notification;
import java.util.ArrayDeque;

class PgDecoder
extends ChannelInboundHandlerAdapter {
    private final ArrayDeque<PgCommandCodec<?, ?>> inflight;
    private ByteBufAllocator alloc;
    private ByteBuf in;
    private static final byte I = 73;
    private static final byte T = 84;
    private CommandCompleteProcessor processor = new CommandCompleteProcessor();

    PgDecoder(ArrayDeque<PgCommandCodec<?, ?>> inflight) {
        this.inflight = inflight;
    }

    public void handlerAdded(ChannelHandlerContext ctx) throws Exception {
        this.alloc = ctx.alloc();
    }

    public void handlerRemoved(ChannelHandlerContext ctx) throws Exception {
        if (this.in != null) {
            ByteBuf buff = this.in;
            this.in = null;
            buff.release();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void channelRead(ChannelHandlerContext ctx, Object msg) {
        buff = (ByteBuf)msg;
        if (this.in == null) {
            this.in = buff;
        } else {
            if (this.in instanceof CompositeByteBuf) {
                composite = (CompositeByteBuf)this.in;
            } else {
                composite = this.alloc.compositeBuffer();
                composite.addComponent(true, this.in);
                this.in = composite;
            }
            composite.addComponent(true, buff);
        }
lbl14:
        // 8 sources

        block9: while ((available = this.in.readableBytes()) >= 5 && (length = this.in.getInt((beginIdx = this.in.readerIndex()) + 1)) + 1 <= available) {
            id = this.in.getByte(beginIdx);
            endIdx = beginIdx + length + 1;
            writerIndex = this.in.writerIndex();
            try {
                this.in.setIndex(beginIdx + 5, endIdx);
                switch (id) {
                    case 90: {
                        this.decodeReadyForQuery(ctx, this.in);
                        ** break;
                    }
                    case 68: {
                        this.decodeDataRow(this.in);
                        ** break;
                    }
                    case 67: {
                        this.decodeCommandComplete(this.in);
                        ** break;
                    }
                    case 50: {
                        this.decodeBindComplete();
                        ** break;
                    }
                    default: {
                        this.decodeMessage(ctx, id, this.in);
                        continue block9;
                    }
                }
            }
            finally {
                this.in.setIndex(endIdx, writerIndex);
            }
        }
        if (this.in != null && !this.in.isReadable()) {
            this.in.release();
            this.in = null;
        }
    }

    private void decodeMessage(ChannelHandlerContext ctx, byte id, ByteBuf in) {
        switch (id) {
            case 84: {
                this.decodeRowDescription(in);
                break;
            }
            case 69: {
                this.decodeError(in);
                break;
            }
            case 78: {
                this.decodeNotice(in);
                break;
            }
            case 82: {
                this.decodeAuthentication(in);
                break;
            }
            case 73: {
                this.decodeEmptyQueryResponse();
                break;
            }
            case 49: {
                this.decodeParseComplete();
                break;
            }
            case 51: {
                this.decodeCloseComplete();
                break;
            }
            case 110: {
                this.decodeNoData();
                break;
            }
            case 115: {
                this.decodePortalSuspended();
                break;
            }
            case 116: {
                this.decodeParameterDescription(in);
                break;
            }
            case 83: {
                this.decodeParameterStatus(in);
                break;
            }
            case 75: {
                this.decodeBackendKeyData(in);
                break;
            }
            case 65: {
                this.decodeNotificationResponse(ctx, in);
                break;
            }
            default: {
                throw new UnsupportedOperationException();
            }
        }
    }

    private void decodePortalSuspended() {
        this.inflight.peek().handlePortalSuspended();
    }

    private void decodeCommandComplete(ByteBuf in) {
        int updated = this.processor.parse(in);
        this.inflight.peek().handleCommandComplete(updated);
    }

    private void decodeDataRow(ByteBuf in) {
        PgCommandCodec<?, ?> codec = this.inflight.peek();
        QueryCommandBaseCodec cmd = (QueryCommandBaseCodec)codec;
        int len = in.readUnsignedShort();
        cmd.decoder.handleRow(len, in);
    }

    private void decodeRowDescription(ByteBuf in) {
        PgColumnDesc[] columns = new PgColumnDesc[in.readUnsignedShort()];
        for (int c = 0; c < columns.length; ++c) {
            PgColumnDesc column;
            String fieldName = Util.readCStringUTF8(in);
            int tableOID = in.readInt();
            short columnAttributeNumber = in.readShort();
            int typeOID = in.readInt();
            short typeSize = in.readShort();
            int typeModifier = in.readInt();
            int textOrBinary = in.readUnsignedShort();
            columns[c] = column = new PgColumnDesc(fieldName, tableOID, columnAttributeNumber, DataType.valueOf(typeOID), typeSize, typeModifier, DataFormat.valueOf(textOrBinary));
        }
        this.inflight.peek().handleRowDescription(columns);
    }

    private void decodeReadyForQuery(ChannelHandlerContext ctx, ByteBuf in) {
        byte id = in.readByte();
        if (id != 73 && id != 84) {
            ctx.fireChannelRead((Object)TxFailedEvent.INSTANCE);
        }
        this.inflight.peek().handleReadyForQuery();
    }

    private void decodeError(ByteBuf in) {
        ErrorResponse response = new ErrorResponse();
        this.decodeErrorOrNotice(response, in);
        if (!"57P01".equals(response.getCode())) {
            PgCommandCodec<?, ?> cmd = this.inflight.peek();
            cmd.handleErrorResponse(response);
        }
    }

    private void decodeNotice(ByteBuf in) {
        NoticeResponse response = new NoticeResponse();
        this.decodeErrorOrNotice(response, in);
        this.inflight.peek().handleNoticeResponse(response);
    }

    private void decodeErrorOrNotice(Response response, ByteBuf in) {
        byte type;
        block19: while ((type = in.readByte()) != 0) {
            switch (type) {
                case 83: {
                    response.setSeverity(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 67: {
                    response.setCode(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 77: {
                    response.setMessage(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 68: {
                    response.setDetail(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 72: {
                    response.setHint(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 112: {
                    response.setInternalPosition(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 113: {
                    response.setInternalQuery(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 80: {
                    response.setPosition(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 87: {
                    response.setWhere(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 70: {
                    response.setFile(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 76: {
                    response.setLine(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 82: {
                    response.setRoutine(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 115: {
                    response.setSchema(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 116: {
                    response.setTable(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 99: {
                    response.setColumn(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 100: {
                    response.setDataType(Util.readCStringUTF8(in));
                    continue block19;
                }
                case 110: {
                    response.setConstraint(Util.readCStringUTF8(in));
                    continue block19;
                }
            }
            Util.readCStringUTF8(in);
        }
    }

    private void decodeAuthentication(ByteBuf in) {
        int type = in.readInt();
        switch (type) {
            case 0: {
                this.inflight.peek().handleAuthenticationOk();
                break;
            }
            case 5: {
                byte[] salt = new byte[4];
                in.readBytes(salt);
                this.inflight.peek().handleAuthenticationMD5Password(salt);
                break;
            }
            case 3: {
                this.inflight.peek().handleAuthenticationClearTextPassword();
                break;
            }
            case 10: {
                this.inflight.peek().handleAuthenticationSasl(in);
                break;
            }
            case 11: {
                this.inflight.peek().handleAuthenticationSaslContinue(in);
                break;
            }
            case 12: {
                this.inflight.peek().handleAuthenticationSaslFinal(in);
                break;
            }
            default: {
                throw new UnsupportedOperationException("Authentication type " + type + " is not supported in the client");
            }
        }
    }

    private void decodeParseComplete() {
        this.inflight.peek().handleParseComplete();
    }

    private void decodeBindComplete() {
        this.inflight.peek().handleBindComplete();
    }

    private void decodeCloseComplete() {
        this.inflight.peek().handleCloseComplete();
    }

    private void decodeNoData() {
        this.inflight.peek().handleNoData();
    }

    private void decodeParameterDescription(ByteBuf in) {
        DataType[] paramDataTypes = new DataType[in.readUnsignedShort()];
        for (int c = 0; c < paramDataTypes.length; ++c) {
            paramDataTypes[c] = DataType.valueOf(in.readInt());
        }
        this.inflight.peek().handleParameterDescription(new PgParamDesc(paramDataTypes));
    }

    private void decodeParameterStatus(ByteBuf in) {
        String key = Util.readCStringUTF8(in);
        String value = Util.readCStringUTF8(in);
        this.inflight.peek().handleParameterStatus(key, value);
    }

    private void decodeEmptyQueryResponse() {
        this.inflight.peek().handleEmptyQueryResponse();
    }

    private void decodeBackendKeyData(ByteBuf in) {
        int processId = in.readInt();
        int secretKey = in.readInt();
        this.inflight.peek().handleBackendKeyData(processId, secretKey);
    }

    private void decodeNotificationResponse(ChannelHandlerContext ctx, ByteBuf in) {
        ctx.fireChannelRead((Object)new Notification(in.readInt(), Util.readCStringUTF8(in), Util.readCStringUTF8(in)));
    }

    static class CommandCompleteProcessor
    implements ByteProcessor {
        private static final byte SPACE = 32;
        private int rows;
        boolean afterSpace;

        CommandCompleteProcessor() {
        }

        int parse(ByteBuf in) {
            this.afterSpace = false;
            this.rows = 0;
            in.forEachByte(in.readerIndex(), in.readableBytes() - 1, (ByteProcessor)this);
            return this.rows;
        }

        public boolean process(byte value) throws Exception {
            boolean space;
            boolean bl = space = value == 32;
            if (this.afterSpace) {
                this.rows = space ? 0 : this.rows * 10 + (value - 48);
            } else {
                this.afterSpace = space;
            }
            return true;
        }
    }
}

