/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.codegen.annotations.DataObject;
import io.vertx.codegen.annotations.GenIgnore;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonObject;
import io.vertx.core.net.JdkSSLEngineOptions;
import io.vertx.core.net.JksOptions;
import io.vertx.core.net.KeyCertOptions;
import io.vertx.core.net.OpenSSLEngineOptions;
import io.vertx.core.net.PemKeyCertOptions;
import io.vertx.core.net.PemTrustOptions;
import io.vertx.core.net.PfxOptions;
import io.vertx.core.net.ProxyOptions;
import io.vertx.core.net.SSLEngineOptions;
import io.vertx.core.net.SocketAddress;
import io.vertx.core.net.TrustOptions;
import io.vertx.core.tracing.TracingPolicy;
import io.vertx.pgclient.PgConnectOptionsConverter;
import io.vertx.pgclient.SslMode;
import io.vertx.pgclient.impl.PgConnectionUriParser;
import io.vertx.sqlclient.SqlConnectOptions;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.function.Predicate;

@DataObject(generateConverter=true)
public class PgConnectOptions
extends SqlConnectOptions {
    public static final String DEFAULT_HOST = "localhost";
    public static int DEFAULT_PORT = 5432;
    public static final String DEFAULT_DATABASE = "db";
    public static final String DEFAULT_USER = "user";
    public static final String DEFAULT_PASSWORD = "pass";
    public static final int DEFAULT_PIPELINING_LIMIT = 256;
    public static final SslMode DEFAULT_SSLMODE = SslMode.DISABLE;
    public static final Map<String, String> DEFAULT_PROPERTIES;
    private int pipeliningLimit = 256;
    private SslMode sslMode = DEFAULT_SSLMODE;

    public static PgConnectOptions wrap(SqlConnectOptions options) {
        if (options instanceof PgConnectOptions) {
            return (PgConnectOptions)options;
        }
        return new PgConnectOptions(options);
    }

    public static PgConnectOptions fromUri(String connectionUri) throws IllegalArgumentException {
        JsonObject parsedConfiguration = PgConnectionUriParser.parse(connectionUri);
        return new PgConnectOptions(parsedConfiguration);
    }

    public static PgConnectOptions fromEnv() {
        PgConnectOptions pgConnectOptions = new PgConnectOptions();
        if (System.getenv("PGHOSTADDR") == null) {
            if (System.getenv("PGHOST") != null) {
                pgConnectOptions.setHost(System.getenv("PGHOST"));
            }
        } else {
            pgConnectOptions.setHost(System.getenv("PGHOSTADDR"));
        }
        if (System.getenv("PGPORT") != null) {
            try {
                pgConnectOptions.setPort(Integer.parseInt(System.getenv("PGPORT")));
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        if (System.getenv("PGDATABASE") != null) {
            pgConnectOptions.setDatabase(System.getenv("PGDATABASE"));
        }
        if (System.getenv("PGUSER") != null) {
            pgConnectOptions.setUser(System.getenv("PGUSER"));
        }
        if (System.getenv("PGPASSWORD") != null) {
            pgConnectOptions.setPassword(System.getenv("PGPASSWORD"));
        }
        if (System.getenv("PGSSLMODE") != null) {
            pgConnectOptions.setSslMode(SslMode.of(System.getenv("PGSSLMODE")));
        }
        return pgConnectOptions;
    }

    public PgConnectOptions() {
    }

    public PgConnectOptions(JsonObject json) {
        super(json);
        PgConnectOptionsConverter.fromJson((Iterable<Map.Entry<String, Object>>)json, this);
    }

    public PgConnectOptions(SqlConnectOptions other) {
        super(other);
        if (other instanceof PgConnectOptions) {
            PgConnectOptions opts = (PgConnectOptions)other;
            this.pipeliningLimit = opts.pipeliningLimit;
            this.sslMode = opts.sslMode;
        }
    }

    public PgConnectOptions(PgConnectOptions other) {
        super((SqlConnectOptions)other);
        this.pipeliningLimit = other.pipeliningLimit;
        this.sslMode = other.sslMode;
    }

    public PgConnectOptions setHost(String host) {
        return (PgConnectOptions)super.setHost(host);
    }

    public PgConnectOptions setPort(int port) {
        return (PgConnectOptions)super.setPort(port);
    }

    public PgConnectOptions setUser(String user) {
        return (PgConnectOptions)super.setUser(user);
    }

    public PgConnectOptions setPassword(String password) {
        return (PgConnectOptions)super.setPassword(password);
    }

    public PgConnectOptions setDatabase(String database) {
        return (PgConnectOptions)super.setDatabase(database);
    }

    public int getPipeliningLimit() {
        return this.pipeliningLimit;
    }

    public PgConnectOptions setPipeliningLimit(int pipeliningLimit) {
        if (pipeliningLimit < 1) {
            throw new IllegalArgumentException();
        }
        this.pipeliningLimit = pipeliningLimit;
        return this;
    }

    public PgConnectOptions setCachePreparedStatements(boolean cachePreparedStatements) {
        return (PgConnectOptions)super.setCachePreparedStatements(cachePreparedStatements);
    }

    public PgConnectOptions setPreparedStatementCacheMaxSize(int preparedStatementCacheMaxSize) {
        return (PgConnectOptions)super.setPreparedStatementCacheMaxSize(preparedStatementCacheMaxSize);
    }

    @GenIgnore
    public PgConnectOptions setPreparedStatementCacheSqlFilter(Predicate<String> predicate) {
        return (PgConnectOptions)super.setPreparedStatementCacheSqlFilter(predicate);
    }

    public PgConnectOptions setPreparedStatementCacheSqlLimit(int preparedStatementCacheSqlLimit) {
        return (PgConnectOptions)super.setPreparedStatementCacheSqlLimit(preparedStatementCacheSqlLimit);
    }

    public PgConnectOptions setProperties(Map<String, String> properties) {
        return (PgConnectOptions)super.setProperties(properties);
    }

    @GenIgnore
    public PgConnectOptions addProperty(String key, String value) {
        return (PgConnectOptions)super.addProperty(key, value);
    }

    public SslMode getSslMode() {
        return this.sslMode;
    }

    public PgConnectOptions setSslMode(SslMode sslmode) {
        this.sslMode = sslmode;
        return this;
    }

    public PgConnectOptions setSendBufferSize(int sendBufferSize) {
        return (PgConnectOptions)super.setSendBufferSize(sendBufferSize);
    }

    public PgConnectOptions setReceiveBufferSize(int receiveBufferSize) {
        return (PgConnectOptions)super.setReceiveBufferSize(receiveBufferSize);
    }

    public PgConnectOptions setReuseAddress(boolean reuseAddress) {
        return (PgConnectOptions)super.setReuseAddress(reuseAddress);
    }

    public PgConnectOptions setTrafficClass(int trafficClass) {
        return (PgConnectOptions)super.setTrafficClass(trafficClass);
    }

    public PgConnectOptions setTcpNoDelay(boolean tcpNoDelay) {
        return (PgConnectOptions)super.setTcpNoDelay(tcpNoDelay);
    }

    public PgConnectOptions setTcpKeepAlive(boolean tcpKeepAlive) {
        return (PgConnectOptions)super.setTcpKeepAlive(tcpKeepAlive);
    }

    public PgConnectOptions setSoLinger(int soLinger) {
        return (PgConnectOptions)super.setSoLinger(soLinger);
    }

    public PgConnectOptions setIdleTimeout(int idleTimeout) {
        return (PgConnectOptions)super.setIdleTimeout(idleTimeout);
    }

    public PgConnectOptions setIdleTimeoutUnit(TimeUnit idleTimeoutUnit) {
        return (PgConnectOptions)super.setIdleTimeoutUnit(idleTimeoutUnit);
    }

    public PgConnectOptions setSsl(boolean ssl) {
        if (ssl) {
            this.setSslMode(SslMode.VERIFY_CA);
        } else {
            this.setSslMode(SslMode.DISABLE);
        }
        return this;
    }

    public PgConnectOptions setKeyCertOptions(KeyCertOptions options) {
        return (PgConnectOptions)super.setKeyCertOptions(options);
    }

    public PgConnectOptions setKeyStoreOptions(JksOptions options) {
        return (PgConnectOptions)super.setKeyStoreOptions(options);
    }

    public PgConnectOptions setPfxKeyCertOptions(PfxOptions options) {
        return (PgConnectOptions)super.setPfxKeyCertOptions(options);
    }

    public PgConnectOptions setPemKeyCertOptions(PemKeyCertOptions options) {
        return (PgConnectOptions)super.setPemKeyCertOptions(options);
    }

    public PgConnectOptions setTrustOptions(TrustOptions options) {
        return (PgConnectOptions)super.setTrustOptions(options);
    }

    public PgConnectOptions setTrustStoreOptions(JksOptions options) {
        return (PgConnectOptions)super.setTrustStoreOptions(options);
    }

    public PgConnectOptions setPemTrustOptions(PemTrustOptions options) {
        return (PgConnectOptions)super.setPemTrustOptions(options);
    }

    public PgConnectOptions setPfxTrustOptions(PfxOptions options) {
        return (PgConnectOptions)super.setPfxTrustOptions(options);
    }

    public PgConnectOptions addEnabledCipherSuite(String suite) {
        return (PgConnectOptions)super.addEnabledCipherSuite(suite);
    }

    public PgConnectOptions addEnabledSecureTransportProtocol(String protocol) {
        return (PgConnectOptions)super.addEnabledSecureTransportProtocol(protocol);
    }

    public PgConnectOptions addCrlPath(String crlPath) throws NullPointerException {
        return (PgConnectOptions)super.addCrlPath(crlPath);
    }

    public PgConnectOptions addCrlValue(Buffer crlValue) throws NullPointerException {
        return (PgConnectOptions)super.addCrlValue(crlValue);
    }

    public PgConnectOptions setTrustAll(boolean trustAll) {
        return (PgConnectOptions)super.setTrustAll(trustAll);
    }

    public PgConnectOptions setConnectTimeout(int connectTimeout) {
        return (PgConnectOptions)super.setConnectTimeout(connectTimeout);
    }

    public PgConnectOptions setMetricsName(String metricsName) {
        return (PgConnectOptions)super.setMetricsName(metricsName);
    }

    public PgConnectOptions setReconnectAttempts(int attempts) {
        return (PgConnectOptions)super.setReconnectAttempts(attempts);
    }

    public PgConnectOptions setHostnameVerificationAlgorithm(String hostnameVerificationAlgorithm) {
        return (PgConnectOptions)super.setHostnameVerificationAlgorithm(hostnameVerificationAlgorithm);
    }

    public PgConnectOptions setLogActivity(boolean logEnabled) {
        return (PgConnectOptions)super.setLogActivity(logEnabled);
    }

    public PgConnectOptions setReconnectInterval(long interval) {
        return (PgConnectOptions)super.setReconnectInterval(interval);
    }

    public PgConnectOptions setProxyOptions(ProxyOptions proxyOptions) {
        return (PgConnectOptions)super.setProxyOptions(proxyOptions);
    }

    public PgConnectOptions setLocalAddress(String localAddress) {
        return (PgConnectOptions)super.setLocalAddress(localAddress);
    }

    public PgConnectOptions setUseAlpn(boolean useAlpn) {
        return (PgConnectOptions)super.setUseAlpn(useAlpn);
    }

    public PgConnectOptions setSslEngineOptions(SSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setJdkSslEngineOptions(JdkSSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setJdkSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setOpenSslEngineOptions(OpenSSLEngineOptions sslEngineOptions) {
        return (PgConnectOptions)super.setOpenSslEngineOptions(sslEngineOptions);
    }

    public PgConnectOptions setReusePort(boolean reusePort) {
        return (PgConnectOptions)super.setReusePort(reusePort);
    }

    public PgConnectOptions setTcpFastOpen(boolean tcpFastOpen) {
        return (PgConnectOptions)super.setTcpFastOpen(tcpFastOpen);
    }

    public PgConnectOptions setTcpCork(boolean tcpCork) {
        return (PgConnectOptions)super.setTcpCork(tcpCork);
    }

    public PgConnectOptions setTcpQuickAck(boolean tcpQuickAck) {
        return (PgConnectOptions)super.setTcpQuickAck(tcpQuickAck);
    }

    public PgConnectOptions setEnabledSecureTransportProtocols(Set<String> enabledSecureTransportProtocols) {
        return (PgConnectOptions)super.setEnabledSecureTransportProtocols(enabledSecureTransportProtocols);
    }

    public PgConnectOptions setSslHandshakeTimeout(long sslHandshakeTimeout) {
        return (PgConnectOptions)super.setSslHandshakeTimeout(sslHandshakeTimeout);
    }

    public PgConnectOptions setSslHandshakeTimeoutUnit(TimeUnit sslHandshakeTimeoutUnit) {
        return (PgConnectOptions)super.setSslHandshakeTimeoutUnit(sslHandshakeTimeoutUnit);
    }

    public PgConnectOptions setTracingPolicy(TracingPolicy tracingPolicy) {
        return (PgConnectOptions)super.setTracingPolicy(tracingPolicy);
    }

    protected void init() {
        this.setHost(DEFAULT_HOST);
        this.setPort(DEFAULT_PORT);
        this.setUser(DEFAULT_USER);
        this.setPassword(DEFAULT_PASSWORD);
        this.setDatabase(DEFAULT_DATABASE);
        this.setProperties(new HashMap<String, String>(DEFAULT_PROPERTIES));
    }

    public JsonObject toJson() {
        JsonObject json = super.toJson();
        PgConnectOptionsConverter.toJson(this, json);
        return json;
    }

    @GenIgnore
    public SocketAddress getSocketAddress() {
        if (!this.isUsingDomainSocket()) {
            return super.getSocketAddress();
        }
        return SocketAddress.domainSocketAddress((String)(this.getHost() + "/.s.PGSQL." + this.getPort()));
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (!(o instanceof PgConnectOptions)) {
            return false;
        }
        if (!super.equals(o)) {
            return false;
        }
        PgConnectOptions that = (PgConnectOptions)((Object)o);
        if (this.pipeliningLimit != that.pipeliningLimit) {
            return false;
        }
        return this.sslMode == that.sslMode;
    }

    public int hashCode() {
        int result = super.hashCode();
        result = 31 * result + this.pipeliningLimit;
        result = 31 * result + this.sslMode.hashCode();
        return result;
    }

    public boolean isUsingDomainSocket() {
        return this.getHost().startsWith("/");
    }

    static {
        HashMap<String, String> defaultProperties = new HashMap<String, String>();
        defaultProperties.put("application_name", "vertx-pg-client");
        defaultProperties.put("client_encoding", "utf8");
        defaultProperties.put("DateStyle", "ISO");
        defaultProperties.put("extra_float_digits", "2");
        DEFAULT_PROPERTIES = Collections.unmodifiableMap(defaultProperties);
    }
}

