/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.Closeable;
import io.vertx.core.Handler;
import io.vertx.core.Vertx;
import io.vertx.core.VertxOptions;
import io.vertx.core.impl.CloseFuture;
import io.vertx.core.impl.ContextInternal;
import io.vertx.core.impl.VertxInternal;
import io.vertx.core.spi.metrics.ClientMetrics;
import io.vertx.core.spi.metrics.VertxMetrics;
import io.vertx.pgclient.PgConnectOptions;
import io.vertx.pgclient.PgPool;
import io.vertx.pgclient.impl.PgConnectionFactory;
import io.vertx.pgclient.impl.PgConnectionImpl;
import io.vertx.pgclient.spi.PgDriver;
import io.vertx.sqlclient.PoolOptions;
import io.vertx.sqlclient.SqlConnectOptions;
import io.vertx.sqlclient.SqlConnection;
import io.vertx.sqlclient.impl.Connection;
import io.vertx.sqlclient.impl.PoolBase;
import io.vertx.sqlclient.impl.SqlConnectionImpl;
import io.vertx.sqlclient.impl.tracing.QueryTracer;
import io.vertx.sqlclient.spi.ConnectionFactory;
import java.util.List;
import java.util.stream.Collectors;

public class PgPoolImpl
extends PoolBase<PgPoolImpl>
implements PgPool {
    public static PgPoolImpl create(VertxInternal vertx, boolean pipelined, List<? extends SqlConnectOptions> servers, PoolOptions poolOptions) {
        VertxInternal vx;
        PgConnectOptions baseConnectOptions = PgConnectOptions.wrap(servers.get(0));
        if (vertx == null) {
            if (Vertx.currentContext() != null) {
                throw new IllegalStateException("Running in a Vertx context => use PgPool#pool(Vertx, PgConnectOptions, PoolOptions) instead");
            }
            VertxOptions vertxOptions = new VertxOptions();
            if (baseConnectOptions.isUsingDomainSocket()) {
                vertxOptions.setPreferNativeTransport(true);
            }
            vx = (VertxInternal)Vertx.vertx((VertxOptions)vertxOptions);
        } else {
            vx = vertx;
        }
        QueryTracer tracer = vx.tracer() == null ? null : new QueryTracer(vx.tracer(), (SqlConnectOptions)baseConnectOptions);
        VertxMetrics vertxMetrics = vx.metricsSPI();
        ClientMetrics metrics = vertxMetrics != null ? vertxMetrics.createClientMetrics(baseConnectOptions.getSocketAddress(), "sql", baseConnectOptions.getMetricsName()) : null;
        int pipeliningLimit = pipelined ? baseConnectOptions.getPipeliningLimit() : 1;
        PgPoolImpl pool = new PgPoolImpl(vx, baseConnectOptions, tracer, metrics, pipeliningLimit, poolOptions);
        PgDriver driver = new PgDriver();
        List lst = servers.stream().map(options -> driver.createConnectionFactory((Vertx)vx, (SqlConnectOptions)options)).collect(Collectors.toList());
        ConnectionFactory factory = ConnectionFactory.roundRobinSelector(lst);
        pool.connectionProvider(arg_0 -> ((ConnectionFactory)factory).connect(arg_0));
        pool.init();
        CloseFuture closeFuture = pool.closeFuture();
        closeFuture.add((Closeable)factory);
        vx.addCloseHook((Closeable)closeFuture);
        if (vertx == null) {
            closeFuture.future().onComplete(ar -> vx.close());
        } else {
            ContextInternal ctx = vx.getContext();
            if (ctx != null) {
                ctx.addCloseHook((Closeable)closeFuture);
            } else {
                vx.addCloseHook((Closeable)closeFuture);
            }
        }
        return pool;
    }

    private PgPoolImpl(VertxInternal vertx, PgConnectOptions baseConnectOptions, QueryTracer tracer, ClientMetrics metrics, int pipeliningLimit, PoolOptions poolOptions) {
        super(vertx, (SqlConnectOptions)baseConnectOptions, null, tracer, metrics, pipeliningLimit, poolOptions);
    }

    public int appendQueryPlaceholder(StringBuilder queryBuilder, int index, int current) {
        queryBuilder.append('$').append(1 + index);
        return index;
    }

    protected SqlConnectionImpl wrap(ContextInternal context, ConnectionFactory factory, Connection conn) {
        return new PgConnectionImpl((PgConnectionFactory)factory, context, conn, this.tracer, this.metrics);
    }

    @Override
    public PgPool connectHandler(Handler<SqlConnection> handler) {
        return (PgPool)super.connectHandler(handler);
    }
}

