/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient;

import io.vertx.core.json.Json;

public class PgException
extends RuntimeException {
    private final String errorMessage;
    private final String severity;
    private final String code;
    private final String detail;
    private final String hint;
    private final String position;
    private final String internalPosition;
    private final String internalQuery;
    private final String where;
    private final String file;
    private final String line;
    private final String routine;
    private final String schema;
    private final String table;
    private final String column;
    private final String dataType;
    private final String constraint;

    private static String formatMessage(String errorMessage, String severity, String code) {
        StringBuilder sb = new StringBuilder();
        if (severity != null) {
            sb.append(severity).append(":");
        }
        if (errorMessage != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append(errorMessage);
        }
        if (code != null) {
            if (sb.length() > 0) {
                sb.append(' ');
            }
            sb.append('(').append(code).append(')');
        }
        return sb.toString();
    }

    public PgException(String errorMessage, String severity, String code, String detail) {
        super(PgException.formatMessage(errorMessage, severity, code));
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.code = code;
        this.detail = detail;
        this.hint = null;
        this.position = null;
        this.internalPosition = null;
        this.internalQuery = null;
        this.where = null;
        this.file = null;
        this.line = null;
        this.routine = null;
        this.schema = null;
        this.table = null;
        this.column = null;
        this.dataType = null;
        this.constraint = null;
    }

    public PgException(String errorMessage, String severity, String code, String detail, String hint, String position, String internalPosition, String internalQuery, String where, String file, String line, String routine, String schema, String table, String column, String dataType, String constraint) {
        super(PgException.formatMessage(errorMessage, severity, code));
        this.errorMessage = errorMessage;
        this.severity = severity;
        this.code = code;
        this.detail = detail;
        this.hint = hint;
        this.position = position;
        this.internalPosition = internalPosition;
        this.internalQuery = internalQuery;
        this.where = where;
        this.file = file;
        this.line = line;
        this.routine = routine;
        this.schema = schema;
        this.table = table;
        this.column = column;
        this.dataType = dataType;
        this.constraint = constraint;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public String getSeverity() {
        return this.severity;
    }

    public String getCode() {
        return this.code;
    }

    public String getDetail() {
        return this.detail;
    }

    public String getHint() {
        return this.hint;
    }

    public String getPosition() {
        return this.position;
    }

    public String getWhere() {
        return this.where;
    }

    public String getFile() {
        return this.file;
    }

    public String getLine() {
        return this.line;
    }

    public String getRoutine() {
        return this.routine;
    }

    public String getSchema() {
        return this.schema;
    }

    public String getTable() {
        return this.table;
    }

    public String getColumn() {
        return this.column;
    }

    public String getDataType() {
        return this.dataType;
    }

    public String getConstraint() {
        return this.constraint;
    }

    public String getInternalPosition() {
        return this.internalPosition;
    }

    public String getInternalQuery() {
        return this.internalQuery;
    }

    private static void append(StringBuffer stringBuffer, String key, String value) {
        if (value != null) {
            stringBuffer.append(", \"").append(key).append("\": ").append(Json.encode((Object)value));
        }
    }
}

