/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgPreparedStatement;
import io.vertx.pgclient.impl.codec.PgRowDesc;
import io.vertx.pgclient.impl.codec.QueryCommandBaseCodec;
import io.vertx.pgclient.impl.codec.RowResultDecoder;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.impl.RowDesc;
import io.vertx.sqlclient.impl.TupleInternal;
import io.vertx.sqlclient.impl.codec.InvalidCachedStatementEvent;
import io.vertx.sqlclient.impl.command.CommandResponse;
import io.vertx.sqlclient.impl.command.ExtendedQueryCommand;

class ExtendedQueryCommandCodec<R, C extends ExtendedQueryCommand<R>>
extends QueryCommandBaseCodec<R, C> {
    private PgEncoder encoder;
    private static final String TABLE_SCHEMA_CHANGE_ERROR_MESSAGE_PATTERN = "bind message has \\d result formats but query has \\d columns";

    ExtendedQueryCommandCodec(C cmd) {
        super(cmd);
        this.decoder = new RowResultDecoder(cmd.collector(), ((PgPreparedStatement)cmd.preparedStatement()).rowDesc());
    }

    @Override
    void encode(PgEncoder encoder) {
        this.encoder = encoder;
        if (((ExtendedQueryCommand)this.cmd).isSuspended()) {
            encoder.writeExecute(((ExtendedQueryCommand)this.cmd).cursorId(), ((ExtendedQueryCommand)this.cmd).fetch());
            encoder.writeSync();
        } else {
            PgPreparedStatement ps = (PgPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement();
            if (((ExtendedQueryCommand)this.cmd).isBatch()) {
                if (((ExtendedQueryCommand)this.cmd).paramsList().isEmpty()) {
                    this.result = false;
                    this.completionHandler.handle((Object)CommandResponse.failure((String)"Can not execute batch query with 0 sets of batch parameters."));
                    return;
                }
                for (TupleInternal param : ((ExtendedQueryCommand)this.cmd).paramsList()) {
                    encoder.writeBind(ps.bind, ((ExtendedQueryCommand)this.cmd).cursorId(), (Tuple)param);
                    encoder.writeExecute(((ExtendedQueryCommand)this.cmd).cursorId(), ((ExtendedQueryCommand)this.cmd).fetch());
                }
            } else {
                encoder.writeBind(ps.bind, ((ExtendedQueryCommand)this.cmd).cursorId(), (Tuple)((ExtendedQueryCommand)this.cmd).params());
                encoder.writeExecute(((ExtendedQueryCommand)this.cmd).cursorId(), ((ExtendedQueryCommand)this.cmd).fetch());
            }
            encoder.writeSync();
        }
    }

    @Override
    void handleParseComplete() {
    }

    @Override
    void handlePortalSuspended() {
        Throwable failure = this.decoder.complete();
        Object result = this.decoder.result();
        PgRowDesc desc = this.decoder.desc;
        int size = this.decoder.size();
        this.decoder.reset();
        this.result = true;
        ((ExtendedQueryCommand)this.cmd).resultHandler().handleResult(0, size, (RowDesc)desc, result, failure);
    }

    @Override
    void handleBindComplete() {
    }

    @Override
    public void handleErrorResponse(ErrorResponse errorResponse) {
        if (((PgPreparedStatement)((ExtendedQueryCommand)this.cmd).preparedStatement()).isCached() && this.isTableSchemaErrorMessage(errorResponse)) {
            this.encoder.channelHandlerContext().fireChannelRead((Object)new InvalidCachedStatementEvent(((ExtendedQueryCommand)this.cmd).preparedStatement().sql()));
        }
        super.handleErrorResponse(errorResponse);
    }

    private boolean isTableSchemaErrorMessage(ErrorResponse errorResponse) {
        return errorResponse.getMessage().matches(TABLE_SCHEMA_CHANGE_ERROR_MESSAGE_PATTERN) || errorResponse.getMessage().equals("cached plan must not change result type");
    }
}

