/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.vertx.core.Handler;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.pgclient.PgException;
import io.vertx.pgclient.impl.codec.ErrorResponse;
import io.vertx.pgclient.impl.codec.NoticeResponse;
import io.vertx.pgclient.impl.codec.PgColumnDesc;
import io.vertx.pgclient.impl.codec.PgEncoder;
import io.vertx.pgclient.impl.codec.PgParamDesc;
import io.vertx.sqlclient.impl.command.CommandBase;
import io.vertx.sqlclient.impl.command.CommandResponse;
import java.util.Arrays;

abstract class PgCommandCodec<R, C extends CommandBase<R>> {
    private static final Logger logger = LoggerFactory.getLogger(PgCommandCodec.class);
    Handler<? super CommandResponse<R>> completionHandler;
    Handler<NoticeResponse> noticeHandler;
    PgException failure;
    R result;
    final C cmd;

    PgCommandCodec(C cmd) {
        this.cmd = cmd;
    }

    abstract void encode(PgEncoder var1);

    void handleBackendKeyData(int processId, int secretKey) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BackendKeyData"));
    }

    void handleEmptyQueryResponse() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message EmptyQueryResponse"));
    }

    void handleParameterDescription(PgParamDesc paramDesc) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParameterDescription"));
    }

    void handleParseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message ParseComplete"));
    }

    void handleCloseComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CloseComplete"));
    }

    void handleRowDescription(PgColumnDesc[] columnDescs) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + Arrays.asList(columnDescs)));
    }

    void handleNoData() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message NoData"));
    }

    void handleNoticeResponse(NoticeResponse noticeResponse) {
        this.noticeHandler.handle((Object)noticeResponse);
    }

    void handleErrorResponse(ErrorResponse errorResponse) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message " + errorResponse));
    }

    void handlePortalSuspended() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message PortalSuspended"));
    }

    void handleBindComplete() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message BindComplete"));
    }

    void handleCommandComplete(int updated) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message CommandComplete"));
    }

    void handleAuthenticationMD5Password(byte[] salt) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationMD5Password"));
    }

    void handleAuthenticationSasl(ByteBuf in) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationSasl"));
    }

    void handleAuthenticationSaslContinue(ByteBuf in) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationSaslContinue"));
    }

    void handleAuthenticationSaslFinal(ByteBuf in) {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationSaslFinal"));
    }

    void handleAuthenticationClearTextPassword() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationClearTextPassword"));
    }

    void handleAuthenticationOk() {
        logger.warn((Object)(this.getClass().getSimpleName() + " should handle message AuthenticationOk"));
    }

    void handleParameterStatus(String key, String value) {
        logger.debug((Object)("Parameter " + key + " changed to " + value));
    }

    void handleReadyForQuery() {
        CommandResponse resp = this.failure != null ? CommandResponse.failure((Throwable)((Object)this.failure)) : CommandResponse.success(this.result);
        this.completionHandler.handle((Object)resp);
    }
}

