/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl.codec;

import io.netty.buffer.ByteBuf;
import io.netty.buffer.Unpooled;
import io.netty.handler.codec.DecoderException;
import io.netty.util.ByteProcessor;
import io.vertx.core.buffer.Buffer;
import io.vertx.core.buffer.impl.VertxByteBufAllocator;
import io.vertx.core.impl.logging.Logger;
import io.vertx.core.impl.logging.LoggerFactory;
import io.vertx.core.json.Json;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Inet;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Money;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.pgclient.impl.codec.DataType;
import io.vertx.pgclient.impl.util.UTF8StringEndDetector;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.codec.CommonCodec;
import java.net.Inet4Address;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.time.Duration;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.time.Period;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.ChronoField;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.List;
import java.util.Locale;
import java.util.UUID;
import java.util.concurrent.TimeUnit;
import java.util.function.IntFunction;

public class DataTypeCodec {
    private static final Logger logger = LoggerFactory.getLogger(DataTypeCodec.class);
    private static final String[] empty_string_array = new String[0];
    private static final LocalDate[] empty_local_date_array = new LocalDate[0];
    private static final LocalTime[] empty_local_time_array = new LocalTime[0];
    private static final OffsetTime[] empty_offset_time_array = new OffsetTime[0];
    private static final LocalDateTime[] empty_local_date_time_array = new LocalDateTime[0];
    private static final OffsetDateTime[] empty_offset_date_time_array = new OffsetDateTime[0];
    private static final Buffer[] empty_buffer_array = new Buffer[0];
    private static final UUID[] empty_uuid_array = new UUID[0];
    private static final Object[] empty_json_array = new Object[0];
    private static final Numeric[] empty_numeric_array = new Numeric[0];
    private static final Point[] empty_point_array = new Point[0];
    private static final Line[] empty_line_array = new Line[0];
    private static final LineSegment[] empty_lseg_array = new LineSegment[0];
    private static final Box[] empty_box_array = new Box[0];
    private static final Path[] empty_path_array = new Path[0];
    private static final Polygon[] empty_polygon_array = new Polygon[0];
    private static final Circle[] empty_circle_array = new Circle[0];
    private static final Interval[] empty_interval_array = new Interval[0];
    private static final Boolean[] empty_boolean_array = new Boolean[0];
    private static final Integer[] empty_integer_array = new Integer[0];
    private static final Short[] empty_short_array = new Short[0];
    private static final Long[] empty_long_array = new Long[0];
    private static final Float[] empty_float_array = new Float[0];
    private static final Double[] empty_double_array = new Double[0];
    private static final LocalDate LOCAL_DATE_EPOCH = LocalDate.of(2000, 1, 1);
    private static final LocalDateTime LOCAL_DATE_TIME_EPOCH = LocalDateTime.of(2000, 1, 1, 0, 0, 0);
    private static final OffsetDateTime OFFSET_DATE_TIME_EPOCH = LocalDateTime.of(2000, 1, 1, 0, 0, 0).atOffset(ZoneOffset.UTC);
    private static final Inet[] empty_inet_array = new Inet[0];
    private static final Money[] empty_money_array = new Money[0];
    public static final Object REFUSED_SENTINEL = new Object();
    private static final IntFunction<Boolean[]> BOOLEAN_ARRAY_FACTORY = size -> size == 0 ? empty_boolean_array : new Boolean[size];
    private static final IntFunction<Short[]> SHORT_ARRAY_FACTORY = size -> size == 0 ? empty_short_array : new Short[size];
    private static final IntFunction<Integer[]> INTEGER_ARRAY_FACTORY = size -> size == 0 ? empty_integer_array : new Integer[size];
    private static final IntFunction<Long[]> LONG_ARRAY_FACTORY = size -> size == 0 ? empty_long_array : new Long[size];
    private static final IntFunction<Float[]> FLOAT_ARRAY_FACTORY = size -> size == 0 ? empty_float_array : new Float[size];
    private static final IntFunction<Double[]> DOUBLE_ARRAY_FACTORY = size -> size == 0 ? empty_double_array : new Double[size];
    private static final IntFunction<String[]> STRING_ARRAY_FACTORY = size -> size == 0 ? empty_string_array : new String[size];
    private static final IntFunction<LocalDate[]> LOCALDATE_ARRAY_FACTORY = size -> size == 0 ? empty_local_date_array : new LocalDate[size];
    private static final IntFunction<LocalTime[]> LOCALTIME_ARRAY_FACTORY = size -> size == 0 ? empty_local_time_array : new LocalTime[size];
    private static final IntFunction<OffsetTime[]> OFFSETTIME_ARRAY_FACTORY = size -> size == 0 ? empty_offset_time_array : new OffsetTime[size];
    private static final IntFunction<LocalDateTime[]> LOCALDATETIME_ARRAY_FACTORY = size -> size == 0 ? empty_local_date_time_array : new LocalDateTime[size];
    private static final IntFunction<OffsetDateTime[]> OFFSETDATETIME_ARRAY_FACTORY = size -> size == 0 ? empty_offset_date_time_array : new OffsetDateTime[size];
    private static final IntFunction<Buffer[]> BUFFER_ARRAY_FACTORY = size -> size == 0 ? empty_buffer_array : new Buffer[size];
    private static final IntFunction<UUID[]> UUID_ARRAY_FACTORY = size -> size == 0 ? empty_uuid_array : new UUID[size];
    private static final IntFunction<Object[]> JSON_ARRAY_FACTORY = size -> size == 0 ? empty_json_array : new Object[size];
    private static final IntFunction<Numeric[]> NUMERIC_ARRAY_FACTORY = size -> size == 0 ? empty_numeric_array : new Numeric[size];
    private static final IntFunction<Point[]> POINT_ARRAY_FACTORY = size -> size == 0 ? empty_point_array : new Point[size];
    private static final IntFunction<Line[]> LINE_ARRAY_FACTORY = size -> size == 0 ? empty_line_array : new Line[size];
    private static final IntFunction<LineSegment[]> LSEG_ARRAY_FACTORY = size -> size == 0 ? empty_lseg_array : new LineSegment[size];
    private static final IntFunction<Box[]> BOX_ARRAY_FACTORY = size -> size == 0 ? empty_box_array : new Box[size];
    private static final IntFunction<Path[]> PATH_ARRAY_FACTORY = size -> size == 0 ? empty_path_array : new Path[size];
    private static final IntFunction<Polygon[]> POLYGON_ARRAY_FACTORY = size -> size == 0 ? empty_polygon_array : new Polygon[size];
    private static final IntFunction<Circle[]> CIRCLE_ARRAY_FACTORY = size -> size == 0 ? empty_circle_array : new Circle[size];
    private static final IntFunction<Interval[]> INTERVAL_ARRAY_FACTORY = size -> size == 0 ? empty_interval_array : new Interval[size];
    private static final IntFunction<Inet[]> INET_ARRAY_FACTORY = size -> size == 0 ? empty_inet_array : new Inet[size];
    private static final IntFunction<Money[]> MONEY_ARRAY_FACTORY = size -> size == 0 ? empty_money_array : new Money[size];
    private static final DateTimeFormatter TIMETZ_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_TIME).appendOffset("+HH:mm", "00:00").toFormatter();
    private static final DateTimeFormatter TIMESTAMP_FORMAT = new DateTimeFormatterBuilder().parseCaseInsensitive().append(DateTimeFormatter.ISO_LOCAL_DATE).appendLiteral(' ').append(DateTimeFormatter.ISO_LOCAL_TIME).toFormatter();
    private static final DateTimeFormatter TIMESTAMPTZ_FORMAT = new DateTimeFormatterBuilder().append(TIMESTAMP_FORMAT).appendOffset("+HH:mm", "00:00").toFormatter();
    public static final LocalDateTime LDT_PLUS_INFINITY = LOCAL_DATE_TIME_EPOCH.plus(Long.MAX_VALUE, ChronoUnit.MICROS);
    public static final LocalDateTime LDT_MINUS_INFINITY = LocalDateTime.parse("4714-11-24 00:00:00 BC", DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss G", Locale.ROOT));

    static void encodeText(DataType id, Object value, ByteBuf buff) {
        int index = buff.writerIndex();
        buff.writeInt(0);
        DataTypeCodec.textEncode(id, value, buff);
        buff.setInt(index, buff.writerIndex() - index - 4);
    }

    private static void textEncode(DataType id, Object value, ByteBuf buff) {
        switch (id) {
            case NUMERIC: {
                DataTypeCodec.textEncodeNUMERIC((Number)value, buff);
                break;
            }
            case NUMERIC_ARRAY: {
                DataTypeCodec.textEncodeNUMERIC_ARRAY((Number[])value, buff);
                break;
            }
            case UNKNOWN: {
                buff.writeCharSequence((CharSequence)String.valueOf(value), StandardCharsets.UTF_8);
                break;
            }
            default: {
                logger.debug((Object)("Data type " + (Object)((Object)id) + " does not support text encoding"));
                buff.writeCharSequence((CharSequence)String.valueOf(value), StandardCharsets.UTF_8);
            }
        }
    }

    public static void encodeBinary(DataType id, Object value, ByteBuf buff) {
        switch (id) {
            case BOOL: {
                DataTypeCodec.binaryEncodeBOOL((Boolean)value, buff);
                break;
            }
            case BOOL_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Boolean[])value, DataType.BOOL, buff);
                break;
            }
            case INT2: {
                DataTypeCodec.binaryEncodeINT2((Number)value, buff);
                break;
            }
            case INT2_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Number[])value, DataType.INT2, buff);
                break;
            }
            case INT4: {
                DataTypeCodec.binaryEncodeINT4((Number)value, buff);
                break;
            }
            case INT4_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Number[])value, DataType.INT4, buff);
                break;
            }
            case INT8: {
                DataTypeCodec.binaryEncodeINT8((Number)value, buff);
                break;
            }
            case INT8_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Number[])value, DataType.INT8, buff);
                break;
            }
            case FLOAT4: {
                DataTypeCodec.binaryEncodeFLOAT4((Number)value, buff);
                break;
            }
            case FLOAT4_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Number[])value, DataType.FLOAT4, buff);
                break;
            }
            case FLOAT8: {
                DataTypeCodec.binaryEncodeFLOAT8((Number)value, buff);
                break;
            }
            case FLOAT8_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Number[])value, DataType.FLOAT8, buff);
                break;
            }
            case CHAR: {
                DataTypeCodec.binaryEncodeCHAR((String)value, buff);
                break;
            }
            case CHAR_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.CHAR, buff);
                break;
            }
            case VARCHAR: {
                DataTypeCodec.binaryEncodeVARCHAR((String)value, buff);
                break;
            }
            case VARCHAR_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.VARCHAR, buff);
                break;
            }
            case BPCHAR: {
                DataTypeCodec.binaryEncodeBPCHAR((String)value, buff);
                break;
            }
            case BPCHAR_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.BPCHAR, buff);
                break;
            }
            case TEXT: {
                DataTypeCodec.binaryEncodeTEXT((String)value, buff);
                break;
            }
            case TEXT_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.TEXT, buff);
                break;
            }
            case NAME: {
                DataTypeCodec.binaryEncodeNAME((String)value, buff);
                break;
            }
            case NAME_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.NAME, buff);
                break;
            }
            case DATE: {
                DataTypeCodec.binaryEncodeDATE((LocalDate)value, buff);
                break;
            }
            case DATE_ARRAY: {
                DataTypeCodec.binaryEncodeArray((LocalDate[])value, DataType.DATE, buff);
                break;
            }
            case TIME: {
                DataTypeCodec.binaryEncodeTIME((LocalTime)value, buff);
                break;
            }
            case TIME_ARRAY: {
                DataTypeCodec.binaryEncodeArray((LocalTime[])value, DataType.TIME, buff);
                break;
            }
            case TIMETZ: {
                DataTypeCodec.binaryEncodeTIMETZ((OffsetTime)value, buff);
                break;
            }
            case TIMETZ_ARRAY: {
                DataTypeCodec.binaryEncodeArray((OffsetTime[])value, DataType.TIMETZ, buff);
                break;
            }
            case TIMESTAMP: {
                DataTypeCodec.binaryEncodeTIMESTAMP((LocalDateTime)value, buff);
                break;
            }
            case TIMESTAMP_ARRAY: {
                DataTypeCodec.binaryEncodeArray((LocalDateTime[])value, DataType.TIMESTAMP, buff);
                break;
            }
            case TIMESTAMPTZ: {
                DataTypeCodec.binaryEncodeTIMESTAMPTZ((OffsetDateTime)value, buff);
                break;
            }
            case TIMESTAMPTZ_ARRAY: {
                DataTypeCodec.binaryEncodeArray((OffsetDateTime[])value, DataType.TIMESTAMPTZ, buff);
                break;
            }
            case BYTEA: {
                DataTypeCodec.binaryEncodeBYTEA((Buffer)value, buff);
                break;
            }
            case BYTEA_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Buffer[])value, DataType.BYTEA, buff);
                break;
            }
            case UUID: {
                DataTypeCodec.binaryEncodeUUID((UUID)value, buff);
                break;
            }
            case UUID_ARRAY: {
                DataTypeCodec.binaryEncodeArray((UUID[])value, DataType.UUID, buff);
                break;
            }
            case JSON: {
                DataTypeCodec.binaryEncodeJSON(value, buff);
                break;
            }
            case JSON_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Object[])value, DataType.JSON, buff);
                break;
            }
            case JSONB: {
                DataTypeCodec.binaryEncodeJSONB(value, buff);
                break;
            }
            case JSONB_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Object[])value, DataType.JSONB, buff);
                break;
            }
            case POINT: {
                DataTypeCodec.binaryEncodePoint((Point)value, buff);
                break;
            }
            case POINT_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Point[])value, DataType.POINT, buff);
                break;
            }
            case LINE: {
                DataTypeCodec.binaryEncodeLine((Line)value, buff);
                break;
            }
            case LINE_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Line[])value, DataType.LINE, buff);
                break;
            }
            case LSEG: {
                DataTypeCodec.binaryEncodeLseg((LineSegment)value, buff);
                break;
            }
            case LSEG_ARRAY: {
                DataTypeCodec.binaryEncodeArray((LineSegment[])value, DataType.LSEG, buff);
                break;
            }
            case BOX: {
                DataTypeCodec.binaryEncodeBox((Box)value, buff);
                break;
            }
            case BOX_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Box[])value, DataType.BOX, buff);
                break;
            }
            case PATH: {
                DataTypeCodec.binaryEncodePath((Path)value, buff);
                break;
            }
            case PATH_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Path[])value, DataType.PATH, buff);
                break;
            }
            case POLYGON: {
                DataTypeCodec.binaryEncodePolygon((Polygon)value, buff);
                break;
            }
            case POLYGON_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Polygon[])value, DataType.POLYGON, buff);
                break;
            }
            case CIRCLE: {
                DataTypeCodec.binaryEncodeCircle((Circle)value, buff);
                break;
            }
            case CIRCLE_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Circle[])value, DataType.CIRCLE, buff);
                break;
            }
            case INTERVAL: {
                DataTypeCodec.binaryEncodeINTERVAL((Interval)value, buff);
                break;
            }
            case INTERVAL_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Interval[])value, DataType.INTERVAL, buff);
                break;
            }
            case TS_QUERY: {
                DataTypeCodec.binaryEncodeTsQuery((String)value, buff);
                break;
            }
            case TS_QUERY_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.TS_QUERY, buff);
                break;
            }
            case TS_VECTOR: {
                DataTypeCodec.binaryEncodeTsVector((String)value, buff);
                break;
            }
            case TS_VECTOR_ARRAY: {
                DataTypeCodec.binaryEncodeArray((String[])value, DataType.TS_VECTOR, buff);
                break;
            }
            case INET: {
                DataTypeCodec.binaryEncodeInet((Inet)value, buff);
                break;
            }
            case INET_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Inet[])value, DataType.INET, buff);
                break;
            }
            case MONEY: {
                DataTypeCodec.binaryEncodeMoney((Money)value, buff);
                break;
            }
            case MONEY_ARRAY: {
                DataTypeCodec.binaryEncodeArray((Money[])value, DataType.MONEY, buff);
                break;
            }
            default: {
                logger.debug((Object)("Data type " + (Object)((Object)id) + " does not support binary encoding"));
                DataTypeCodec.defaultEncodeBinary(value, buff);
            }
        }
    }

    public static Object decodeBinary(DataType id, int index, int len, ByteBuf buff) {
        switch (id) {
            case BOOL: {
                return DataTypeCodec.binaryDecodeBOOL(index, len, buff);
            }
            case BOOL_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(BOOLEAN_ARRAY_FACTORY, DataType.BOOL, index, len, buff);
            }
            case INT2: {
                return DataTypeCodec.binaryDecodeINT2(index, len, buff);
            }
            case INT2_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(SHORT_ARRAY_FACTORY, DataType.INT2, index, len, buff);
            }
            case INT4: {
                return DataTypeCodec.binaryDecodeINT4(index, len, buff);
            }
            case INT4_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(INTEGER_ARRAY_FACTORY, DataType.INT4, index, len, buff);
            }
            case INT8: {
                return DataTypeCodec.binaryDecodeINT8(index, len, buff);
            }
            case INT8_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LONG_ARRAY_FACTORY, DataType.INT8, index, len, buff);
            }
            case FLOAT4: {
                return DataTypeCodec.binaryDecodeFLOAT4(index, len, buff);
            }
            case FLOAT4_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(FLOAT_ARRAY_FACTORY, DataType.FLOAT4, index, len, buff);
            }
            case FLOAT8: {
                return DataTypeCodec.binaryDecodeFLOAT8(index, len, buff);
            }
            case FLOAT8_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(DOUBLE_ARRAY_FACTORY, DataType.FLOAT8, index, len, buff);
            }
            case CHAR: {
                return DataTypeCodec.binaryDecodeCHAR(index, len, buff);
            }
            case CHAR_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.CHAR, index, len, buff);
            }
            case VARCHAR: {
                return DataTypeCodec.binaryDecodeVARCHAR(index, len, buff);
            }
            case VARCHAR_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.VARCHAR, index, len, buff);
            }
            case BPCHAR: {
                return DataTypeCodec.binaryDecodeBPCHAR(index, len, buff);
            }
            case BPCHAR_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.BPCHAR, index, len, buff);
            }
            case TEXT: {
                return DataTypeCodec.binaryDecodeTEXT(index, len, buff);
            }
            case TEXT_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.TEXT, index, len, buff);
            }
            case NAME: {
                return DataTypeCodec.binaryDecodeNAME(index, len, buff);
            }
            case NAME_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.NAME, index, len, buff);
            }
            case DATE: {
                return DataTypeCodec.binaryDecodeDATE(index, len, buff);
            }
            case DATE_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LOCALDATE_ARRAY_FACTORY, DataType.DATE, index, len, buff);
            }
            case TIME: {
                return DataTypeCodec.binaryDecodeTIME(index, len, buff);
            }
            case TIME_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LOCALTIME_ARRAY_FACTORY, DataType.TIME, index, len, buff);
            }
            case TIMETZ: {
                return DataTypeCodec.binaryDecodeTIMETZ(index, len, buff);
            }
            case TIMETZ_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(OFFSETTIME_ARRAY_FACTORY, DataType.TIMETZ, index, len, buff);
            }
            case TIMESTAMP: {
                return DataTypeCodec.binaryDecodeTIMESTAMP(index, len, buff);
            }
            case TIMESTAMP_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LOCALDATETIME_ARRAY_FACTORY, DataType.TIMESTAMP, index, len, buff);
            }
            case TIMESTAMPTZ: {
                return DataTypeCodec.binaryDecodeTIMESTAMPTZ(index, len, buff);
            }
            case TIMESTAMPTZ_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(OFFSETDATETIME_ARRAY_FACTORY, DataType.TIMESTAMPTZ, index, len, buff);
            }
            case BYTEA: {
                return DataTypeCodec.binaryDecodeBYTEA(index, len, buff);
            }
            case BYTEA_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(BUFFER_ARRAY_FACTORY, DataType.BYTEA, index, len, buff);
            }
            case UUID: {
                return DataTypeCodec.binaryDecodeUUID(index, len, buff);
            }
            case UUID_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(UUID_ARRAY_FACTORY, DataType.UUID, index, len, buff);
            }
            case JSON: {
                return DataTypeCodec.binaryDecodeJSON(index, len, buff);
            }
            case JSON_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(JSON_ARRAY_FACTORY, DataType.JSON, index, len, buff);
            }
            case JSONB: {
                return DataTypeCodec.binaryDecodeJSONB(index, len, buff);
            }
            case JSONB_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(JSON_ARRAY_FACTORY, DataType.JSONB, index, len, buff);
            }
            case POINT: {
                return DataTypeCodec.binaryDecodePoint(index, len, buff);
            }
            case POINT_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(POINT_ARRAY_FACTORY, DataType.POINT, index, len, buff);
            }
            case LINE: {
                return DataTypeCodec.binaryDecodeLine(index, len, buff);
            }
            case LINE_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LINE_ARRAY_FACTORY, DataType.LINE, index, len, buff);
            }
            case LSEG: {
                return DataTypeCodec.binaryDecodeLseg(index, len, buff);
            }
            case LSEG_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(LSEG_ARRAY_FACTORY, DataType.LSEG, index, len, buff);
            }
            case BOX: {
                return DataTypeCodec.binaryDecodeBox(index, len, buff);
            }
            case BOX_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(BOX_ARRAY_FACTORY, DataType.BOX, index, len, buff);
            }
            case PATH: {
                return DataTypeCodec.binaryDecodePath(index, len, buff);
            }
            case PATH_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(PATH_ARRAY_FACTORY, DataType.PATH, index, len, buff);
            }
            case POLYGON: {
                return DataTypeCodec.binaryDecodePolygon(index, len, buff);
            }
            case POLYGON_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(POLYGON_ARRAY_FACTORY, DataType.POLYGON, index, len, buff);
            }
            case CIRCLE: {
                return DataTypeCodec.binaryDecodeCircle(index, len, buff);
            }
            case CIRCLE_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(CIRCLE_ARRAY_FACTORY, DataType.CIRCLE, index, len, buff);
            }
            case INTERVAL: {
                return DataTypeCodec.binaryDecodeINTERVAL(index, len, buff);
            }
            case INTERVAL_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(INTERVAL_ARRAY_FACTORY, DataType.INTERVAL, index, len, buff);
            }
            case TS_QUERY: {
                return DataTypeCodec.binaryDecodeTsQuery(index, len, buff);
            }
            case TS_QUERY_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.TS_QUERY, index, len, buff);
            }
            case TS_VECTOR: {
                return DataTypeCodec.binaryDecodeTsVector(index, len, buff);
            }
            case TS_VECTOR_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(STRING_ARRAY_FACTORY, DataType.TS_VECTOR, index, len, buff);
            }
            case INET: {
                return DataTypeCodec.binaryDecodeInet(index, len, buff);
            }
            case INET_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(INET_ARRAY_FACTORY, DataType.INET, index, len, buff);
            }
            case MONEY: {
                return DataTypeCodec.binaryDecodeMoney(index, len, buff);
            }
            case MONEY_ARRAY: {
                return DataTypeCodec.binaryDecodeArray(MONEY_ARRAY_FACTORY, DataType.MONEY, index, len, buff);
            }
        }
        logger.debug((Object)("Data type " + (Object)((Object)id) + " does not support binary decoding"));
        return DataTypeCodec.defaultDecodeBinary(index, len, buff);
    }

    public static Object decodeText(DataType id, int index, int len, ByteBuf buff) {
        switch (id) {
            case BOOL: {
                return DataTypeCodec.textDecodeBOOL(index, len, buff);
            }
            case BOOL_ARRAY: {
                return DataTypeCodec.textDecodeArray(BOOLEAN_ARRAY_FACTORY, DataType.BOOL, index, len, buff);
            }
            case INT2: {
                return DataTypeCodec.textDecodeINT2(index, len, buff);
            }
            case INT2_ARRAY: {
                return DataTypeCodec.textDecodeArray(SHORT_ARRAY_FACTORY, DataType.INT2, index, len, buff);
            }
            case INT4: {
                return DataTypeCodec.textDecodeINT4(index, len, buff);
            }
            case INT4_ARRAY: {
                return DataTypeCodec.textDecodeArray(INTEGER_ARRAY_FACTORY, DataType.INT4, index, len, buff);
            }
            case INT8: {
                return DataTypeCodec.textDecodeINT8(index, len, buff);
            }
            case INT8_ARRAY: {
                return DataTypeCodec.textDecodeArray(LONG_ARRAY_FACTORY, DataType.INT8, index, len, buff);
            }
            case FLOAT4: {
                return DataTypeCodec.textDecodeFLOAT4(index, len, buff);
            }
            case FLOAT4_ARRAY: {
                return DataTypeCodec.textDecodeArray(FLOAT_ARRAY_FACTORY, DataType.FLOAT4, index, len, buff);
            }
            case FLOAT8: {
                return DataTypeCodec.textDecodeFLOAT8(index, len, buff);
            }
            case FLOAT8_ARRAY: {
                return DataTypeCodec.textDecodeArray(DOUBLE_ARRAY_FACTORY, DataType.FLOAT8, index, len, buff);
            }
            case CHAR: {
                return DataTypeCodec.textDecodeCHAR(index, len, buff);
            }
            case VARCHAR: {
                return DataTypeCodec.textDecodeVARCHAR(index, len, buff);
            }
            case VARCHAR_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.VARCHAR, index, len, buff);
            }
            case BPCHAR: {
                return DataTypeCodec.textDecodeBPCHAR(index, len, buff);
            }
            case BPCHAR_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.BPCHAR, index, len, buff);
            }
            case TEXT: {
                return DataTypeCodec.textdecodeTEXT(index, len, buff);
            }
            case TEXT_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.TEXT, index, len, buff);
            }
            case NAME: {
                return DataTypeCodec.textDecodeNAME(index, len, buff);
            }
            case NAME_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.NAME, index, len, buff);
            }
            case DATE: {
                return DataTypeCodec.textDecodeDATE(index, len, buff);
            }
            case DATE_ARRAY: {
                return DataTypeCodec.textDecodeArray(LOCALDATE_ARRAY_FACTORY, DataType.DATE, index, len, buff);
            }
            case TIME: {
                return DataTypeCodec.textDecodeTIME(index, len, buff);
            }
            case TIME_ARRAY: {
                return DataTypeCodec.textDecodeArray(LOCALTIME_ARRAY_FACTORY, DataType.TIME, index, len, buff);
            }
            case TIMETZ: {
                return DataTypeCodec.textDecodeTIMETZ(index, len, buff);
            }
            case TIMETZ_ARRAY: {
                return DataTypeCodec.textDecodeArray(OFFSETTIME_ARRAY_FACTORY, DataType.TIMETZ, index, len, buff);
            }
            case TIMESTAMP: {
                return DataTypeCodec.textDecodeTIMESTAMP(index, len, buff);
            }
            case TIMESTAMP_ARRAY: {
                return DataTypeCodec.textDecodeArray(LOCALDATETIME_ARRAY_FACTORY, DataType.TIMESTAMP, index, len, buff);
            }
            case TIMESTAMPTZ: {
                return DataTypeCodec.textDecodeTIMESTAMPTZ(index, len, buff);
            }
            case TIMESTAMPTZ_ARRAY: {
                return DataTypeCodec.textDecodeArray(OFFSETDATETIME_ARRAY_FACTORY, DataType.TIMESTAMPTZ, index, len, buff);
            }
            case BYTEA: {
                return DataTypeCodec.textDecodeBYTEA(index, len, buff);
            }
            case BYTEA_ARRAY: {
                return DataTypeCodec.textDecodeArray(BUFFER_ARRAY_FACTORY, DataType.BYTEA, index, len, buff);
            }
            case UUID: {
                return DataTypeCodec.textDecodeUUID(index, len, buff);
            }
            case UUID_ARRAY: {
                return DataTypeCodec.textDecodeArray(UUID_ARRAY_FACTORY, DataType.UUID, index, len, buff);
            }
            case NUMERIC: {
                return DataTypeCodec.textDecodeNUMERIC(index, len, buff);
            }
            case NUMERIC_ARRAY: {
                return DataTypeCodec.textDecodeArray(NUMERIC_ARRAY_FACTORY, DataType.NUMERIC, index, len, buff);
            }
            case JSON: {
                return DataTypeCodec.textDecodeJSON(index, len, buff);
            }
            case JSON_ARRAY: {
                return DataTypeCodec.textDecodeArray(JSON_ARRAY_FACTORY, DataType.JSON, index, len, buff);
            }
            case JSONB: {
                return DataTypeCodec.textDecodeJSONB(index, len, buff);
            }
            case JSONB_ARRAY: {
                return DataTypeCodec.textDecodeArray(JSON_ARRAY_FACTORY, DataType.JSONB, index, len, buff);
            }
            case POINT: {
                return DataTypeCodec.textDecodePOINT(index, len, buff);
            }
            case POINT_ARRAY: {
                return DataTypeCodec.textDecodeArray(POINT_ARRAY_FACTORY, DataType.POINT, index, len, buff);
            }
            case LINE: {
                return DataTypeCodec.textDecodeLine(index, len, buff);
            }
            case LINE_ARRAY: {
                return DataTypeCodec.textDecodeArray(LINE_ARRAY_FACTORY, DataType.LINE, index, len, buff);
            }
            case LSEG: {
                return DataTypeCodec.textDecodeLseg(index, len, buff);
            }
            case LSEG_ARRAY: {
                return DataTypeCodec.textDecodeArray(LSEG_ARRAY_FACTORY, DataType.LSEG, index, len, buff);
            }
            case BOX: {
                return DataTypeCodec.textDecodeBox(index, len, buff);
            }
            case BOX_ARRAY: {
                return DataTypeCodec.textDecodeBoxArray(BOX_ARRAY_FACTORY, index, len, buff);
            }
            case PATH: {
                return DataTypeCodec.textDecodePath(index, len, buff);
            }
            case PATH_ARRAY: {
                return DataTypeCodec.textDecodeArray(PATH_ARRAY_FACTORY, DataType.PATH, index, len, buff);
            }
            case POLYGON: {
                return DataTypeCodec.textDecodePolygon(index, len, buff);
            }
            case POLYGON_ARRAY: {
                return DataTypeCodec.textDecodeArray(POLYGON_ARRAY_FACTORY, DataType.POLYGON, index, len, buff);
            }
            case CIRCLE: {
                return DataTypeCodec.textDecodeCircle(index, len, buff);
            }
            case CIRCLE_ARRAY: {
                return DataTypeCodec.textDecodeArray(CIRCLE_ARRAY_FACTORY, DataType.CIRCLE, index, len, buff);
            }
            case INTERVAL: {
                return DataTypeCodec.textDecodeINTERVAL(index, len, buff);
            }
            case INTERVAL_ARRAY: {
                return DataTypeCodec.textDecodeArray(INTERVAL_ARRAY_FACTORY, DataType.INTERVAL, index, len, buff);
            }
            case TS_QUERY: {
                return DataTypeCodec.textDecodeTsQuery(index, len, buff);
            }
            case TS_QUERY_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.TS_QUERY, index, len, buff);
            }
            case TS_VECTOR: {
                return DataTypeCodec.textDecodeTsVector(index, len, buff);
            }
            case TS_VECTOR_ARRAY: {
                return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.TS_VECTOR, index, len, buff);
            }
            case INET: {
                return DataTypeCodec.textDecodeInet(index, len, buff);
            }
            case INET_ARRAY: {
                return DataTypeCodec.textDecodeArray(INET_ARRAY_FACTORY, DataType.INET, index, len, buff);
            }
            case MONEY: {
                return DataTypeCodec.textDecodeMoney(index, len, buff);
            }
            case MONEY_ARRAY: {
                return DataTypeCodec.textDecodeArray(MONEY_ARRAY_FACTORY, DataType.MONEY, index, len, buff);
            }
        }
        return DataTypeCodec.defaultDecodeText(index, len, buff);
    }

    private static Object defaultDecodeText(int index, int len, ByteBuf buff) {
        if (len > 1 && buff.getByte(index) == 123) {
            return DataTypeCodec.textDecodeArray(STRING_ARRAY_FACTORY, DataType.TEXT, index, len, buff);
        }
        return DataTypeCodec.textdecodeTEXT(index, len, buff);
    }

    private static void defaultEncodeBinary(Object value, ByteBuf buff) {
        buff.writeInt(-1);
    }

    private static Object defaultDecodeBinary(int index, int len, ByteBuf buff) {
        return null;
    }

    private static void binaryEncodeBOOL(Boolean value, ByteBuf buff) {
        buff.writeBoolean(value.booleanValue());
    }

    private static Boolean binaryDecodeBOOL(int index, int len, ByteBuf buff) {
        return buff.getBoolean(index);
    }

    private static Boolean textDecodeBOOL(int index, int len, ByteBuf buff) {
        if (buff.getByte(index) == 116) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    private static Short textDecodeINT2(int index, int len, ByteBuf buff) {
        return (short)CommonCodec.decodeDecStringToLong((int)index, (int)len, (ByteBuf)buff);
    }

    private static Short binaryDecodeINT2(int index, int len, ByteBuf buff) {
        return buff.getShort(index);
    }

    private static void binaryEncodeINT2(Number value, ByteBuf buff) {
        buff.writeShort((int)value.shortValue());
    }

    private static Integer textDecodeINT4(int index, int len, ByteBuf buff) {
        return (int)CommonCodec.decodeDecStringToLong((int)index, (int)len, (ByteBuf)buff);
    }

    private static Integer binaryDecodeINT4(int index, int len, ByteBuf buff) {
        return buff.getInt(index);
    }

    private static void binaryEncodeINT4(Number value, ByteBuf buff) {
        buff.writeInt(value.intValue());
    }

    private static Long textDecodeINT8(int index, int len, ByteBuf buff) {
        return CommonCodec.decodeDecStringToLong((int)index, (int)len, (ByteBuf)buff);
    }

    private static Long binaryDecodeINT8(int index, int len, ByteBuf buff) {
        return buff.getLong(index);
    }

    private static void binaryEncodeINT8(Number value, ByteBuf buff) {
        buff.writeLong(value.longValue());
    }

    private static Float textDecodeFLOAT4(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        return Float.valueOf(Float.parseFloat(cs.toString()));
    }

    private static Float binaryDecodeFLOAT4(int index, int len, ByteBuf buff) {
        return Float.valueOf(buff.getFloat(index));
    }

    private static void binaryEncodeFLOAT4(Number value, ByteBuf buff) {
        buff.writeFloat(value.floatValue());
    }

    private static void binaryEncodeFLOAT8(Number value, ByteBuf buff) {
        buff.writeDouble(value.doubleValue());
    }

    private static Double binaryDecodeFLOAT8(int index, int len, ByteBuf buff) {
        return buff.getDouble(index);
    }

    private static double textDecodeFLOAT8(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        return Double.parseDouble(cs.toString());
    }

    private static Number textDecodeNUMERIC(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        return Numeric.parse((String)cs.toString());
    }

    private static Point textDecodePOINT(int index, int len, ByteBuf buff) {
        int idx = ++index;
        int s = buff.indexOf(idx, idx + len, (byte)44);
        int t = s - idx;
        double x = DataTypeCodec.textDecodeFLOAT8(idx, t, buff);
        double y = DataTypeCodec.textDecodeFLOAT8(s + 1, len - t - 3, buff);
        return new Point(x, y);
    }

    private static Line textDecodeLine(int index, int len, ByteBuf buff) {
        int idxOfFirstSeparator = buff.indexOf(index, index + len, (byte)44);
        int idxOfLastSeparator = buff.indexOf(index + len, index, (byte)44);
        int idx = index + 1;
        double a = DataTypeCodec.textDecodeFLOAT8(idx, idxOfFirstSeparator - idx, buff);
        double b = DataTypeCodec.textDecodeFLOAT8(idxOfFirstSeparator + 1, idxOfLastSeparator - idxOfFirstSeparator - 1, buff);
        double c = DataTypeCodec.textDecodeFLOAT8(idxOfLastSeparator + 1, index + len - idxOfLastSeparator - 2, buff);
        return new Line(a, b, c);
    }

    private static LineSegment textDecodeLseg(int index, int len, ByteBuf buff) {
        int idxOfPointsSeparator = buff.indexOf(index, index + len, (byte)41) + 1;
        int lenOfP1 = idxOfPointsSeparator - index - 1;
        Point p1 = DataTypeCodec.textDecodePOINT(index + 1, lenOfP1, buff);
        Point p2 = DataTypeCodec.textDecodePOINT(idxOfPointsSeparator + 1, len - lenOfP1 - 3, buff);
        return new LineSegment(p1, p2);
    }

    private static Box textDecodeBox(int index, int len, ByteBuf buff) {
        int idxOfPointsSeparator = buff.indexOf(index, index + len, (byte)41) + 1;
        int lenOfUpperRightCornerPoint = idxOfPointsSeparator - index;
        Point upperRightCorner = DataTypeCodec.textDecodePOINT(index, lenOfUpperRightCornerPoint, buff);
        Point lowerLeftCorner = DataTypeCodec.textDecodePOINT(idxOfPointsSeparator + 1, len - lenOfUpperRightCornerPoint - 1, buff);
        return new Box(upperRightCorner, lowerLeftCorner);
    }

    private static Box[] textDecodeBoxArray(IntFunction<Box[]> supplier, int index, int len, ByteBuf buff) {
        ArrayList<Box> boxes = new ArrayList<Box>();
        int start = index + 1;
        int end = index + len - 1;
        while (start < end) {
            int idxOfBoxSeparator = buff.indexOf(start, end + 1, (byte)59);
            if (idxOfBoxSeparator == -1) {
                Box box = DataTypeCodec.textDecodeBox(start, end - start, buff);
                boxes.add(box);
                break;
            }
            int lenOfBox = idxOfBoxSeparator - start;
            Box box = DataTypeCodec.textDecodeBox(start, lenOfBox, buff);
            boxes.add(box);
            start = idxOfBoxSeparator + 1;
        }
        return (Box[])boxes.toArray((Object[])supplier.apply(boxes.size()));
    }

    private static Path textDecodePath(int index, int len, ByteBuf buff) {
        boolean isOpen;
        byte first = buff.getByte(index);
        byte last = buff.getByte(index + len - 1);
        if (first == 40 && last == 41) {
            isOpen = false;
        } else if (first == 91 && last == 93) {
            isOpen = true;
        } else {
            throw new DecoderException("Decoding Path is in wrong syntax");
        }
        List<Point> points = DataTypeCodec.textDecodeMultiplePoints(index + 1, len - 2, buff);
        return new Path(isOpen, points);
    }

    private static Polygon textDecodePolygon(int index, int len, ByteBuf buff) {
        List<Point> points = DataTypeCodec.textDecodeMultiplePoints(index + 1, len - 2, buff);
        return new Polygon(points);
    }

    private static List<Point> textDecodeMultiplePoints(int index, int len, ByteBuf buff) {
        ArrayList<Point> points = new ArrayList<Point>();
        int start = index;
        int end = index + len - 1;
        while (start < end) {
            int rightParenthesis = buff.indexOf(start, end + 1, (byte)41);
            int idxOfPointSeparator = rightParenthesis + 1;
            int lenOfPoint = idxOfPointSeparator - start;
            Point point = DataTypeCodec.textDecodePOINT(start, lenOfPoint, buff);
            points.add(point);
            start = idxOfPointSeparator + 1;
        }
        return points;
    }

    private static Circle textDecodeCircle(int index, int len, ByteBuf buff) {
        int idxOfLastComma = buff.indexOf(index + len - 1, index, (byte)44);
        int lenOfPoint = idxOfLastComma - index - 1;
        Point center = DataTypeCodec.textDecodePOINT(index + 1, lenOfPoint, buff);
        int lenOfRadius = len - lenOfPoint - 3;
        double radius = DataTypeCodec.textDecodeFLOAT8(idxOfLastComma + 1, lenOfRadius, buff);
        return new Circle(center, radius);
    }

    private static Interval textDecodeINTERVAL(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        String value = cs.toString();
        int years = 0;
        int months = 0;
        int days = 0;
        int hours = 0;
        int minutes = 0;
        int seconds = 0;
        int microseconds = 0;
        ArrayList<String> chunks = new ArrayList<String>(7);
        int idx = 0;
        while (true) {
            int newIdx;
            if ((newIdx = value.indexOf(32, idx)) == -1) break;
            chunks.add(value.substring(idx, newIdx));
            idx = newIdx + 1;
        }
        chunks.add(value.substring(idx));
        boolean hasTime = chunks.size() % 2 == 1;
        int dateChunkMax = hasTime ? chunks.size() - 1 : chunks.size();
        block14: for (int i = 0; i < dateChunkMax; i += 2) {
            int val = Integer.parseInt((String)chunks.get(i));
            switch ((String)chunks.get(i + 1)) {
                case "year": 
                case "years": {
                    years = val;
                    continue block14;
                }
                case "mon": 
                case "mons": {
                    months = val;
                    continue block14;
                }
                case "day": 
                case "days": {
                    days = val;
                }
            }
        }
        if (hasTime) {
            boolean isNeg;
            String timeChunk = (String)chunks.get(chunks.size() - 1);
            boolean bl = isNeg = timeChunk.charAt(0) == '-';
            if (isNeg) {
                timeChunk = timeChunk.substring(1);
            }
            int sidx = 0;
            while (true) {
                int newIdx;
                if ((newIdx = timeChunk.indexOf(58, sidx)) == -1) {
                    int m = timeChunk.substring(sidx).indexOf(46);
                    if (m == -1) {
                        seconds = isNeg ? -Integer.parseInt(timeChunk.substring(sidx)) : Integer.parseInt(timeChunk.substring(sidx));
                        break;
                    }
                    seconds = isNeg ? -Integer.parseInt(timeChunk.substring(sidx).substring(0, m)) : Integer.parseInt(timeChunk.substring(sidx).substring(0, m));
                    microseconds = isNeg ? -Integer.parseInt(timeChunk.substring(sidx).substring(m + 1)) : Integer.parseInt(timeChunk.substring(sidx).substring(m + 1));
                    break;
                }
                if (sidx == 0) {
                    hours = isNeg ? -Integer.parseInt(timeChunk.substring(sidx, newIdx)) : Integer.parseInt(timeChunk.substring(sidx, newIdx));
                } else {
                    minutes = isNeg ? -Integer.parseInt(timeChunk.substring(sidx, newIdx)) : Integer.parseInt(timeChunk.substring(sidx, newIdx));
                }
                sidx = newIdx + 1;
            }
        }
        return new Interval(years, months, days, hours, minutes, seconds, microseconds);
    }

    private static void textEncodeNUMERIC(Number value, ByteBuf buff) {
        String s = value.toString();
        buff.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
    }

    private static void textEncodeNUMERIC_ARRAY(Number[] value, ByteBuf buff) {
        DataTypeCodec.textEncodeArray(value, DataType.NUMERIC, buff);
    }

    private static void binaryEncodeCHAR(String value, ByteBuf buff) {
        DataTypeCodec.binaryEncodeTEXT(value, buff);
    }

    private static String textDecodeCHAR(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String binaryDecodeCHAR(int index, int len, ByteBuf buff) {
        return DataTypeCodec.binaryDecodeTEXT(index, len, buff);
    }

    private static void binaryEncodeVARCHAR(String value, ByteBuf buff) {
        String s = String.valueOf(value);
        buff.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
    }

    private static String textDecodeVARCHAR(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String binaryDecodeVARCHAR(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String textDecodeBPCHAR(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeBPCHAR(String value, ByteBuf buff) {
        buff.writeCharSequence((CharSequence)value, StandardCharsets.UTF_8);
    }

    private static String binaryDecodeBPCHAR(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String textdecodeTEXT(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeTEXT(String value, ByteBuf buff) {
        String s = String.valueOf(value);
        buff.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
    }

    private static String binaryDecodeTEXT(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String textDecodeNAME(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeNAME(String value, ByteBuf buff) {
        String s = String.valueOf(value);
        buff.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
    }

    private static String binaryDecodeNAME(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeDATE(LocalDate value, ByteBuf buff) {
        int v = value == LocalDate.MAX ? Integer.MAX_VALUE : (value == LocalDate.MIN ? Integer.MIN_VALUE : (int)(-value.until(LOCAL_DATE_EPOCH, ChronoUnit.DAYS)));
        buff.writeInt(v);
    }

    private static LocalDate binaryDecodeDATE(int index, int len, ByteBuf buff) {
        int val = buff.getInt(index);
        switch (val) {
            case 0x7FFFFFFF: {
                return LocalDate.MAX;
            }
            case -2147483648: {
                return LocalDate.MIN;
            }
        }
        return LOCAL_DATE_EPOCH.plus(val, ChronoUnit.DAYS);
    }

    private static LocalDate textDecodeDATE(int index, int len, ByteBuf buff) {
        String s;
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        switch (s = cs.toString()) {
            case "infinity": {
                return LocalDate.MAX;
            }
            case "-infinity": {
                return LocalDate.MIN;
            }
        }
        return LocalDate.parse(cs);
    }

    private static void binaryEncodeTIME(LocalTime value, ByteBuf buff) {
        buff.writeLong(value.getLong(ChronoField.MICRO_OF_DAY));
    }

    private static LocalTime binaryDecodeTIME(int index, int len, ByteBuf buff) {
        return LocalTime.ofNanoOfDay(buff.getLong(index) * 1000L);
    }

    private static LocalTime textDecodeTIME(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        return LocalTime.parse(cs);
    }

    private static void binaryEncodeTIMETZ(OffsetTime value, ByteBuf buff) {
        buff.writeLong(value.toLocalTime().getLong(ChronoField.MICRO_OF_DAY));
        buff.writeInt(-value.getOffset().getTotalSeconds());
    }

    private static OffsetTime binaryDecodeTIMETZ(int index, int len, ByteBuf buff) {
        return OffsetTime.of(LocalTime.ofNanoOfDay(buff.getLong(index) * 1000L), ZoneOffset.ofTotalSeconds(-buff.getInt(index + 8)));
    }

    private static OffsetTime textDecodeTIMETZ(int index, int len, ByteBuf buff) {
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        return OffsetTime.parse(cs, TIMETZ_FORMAT);
    }

    private static void binaryEncodeTIMESTAMP(LocalDateTime value, ByteBuf buff) {
        if (value.compareTo(LDT_PLUS_INFINITY) >= 0) {
            value = LDT_PLUS_INFINITY;
        } else if (value.compareTo(LDT_MINUS_INFINITY) <= 0) {
            value = LDT_MINUS_INFINITY;
        }
        buff.writeLong(-value.until(LOCAL_DATE_TIME_EPOCH, ChronoUnit.MICROS));
    }

    private static LocalDateTime binaryDecodeTIMESTAMP(int index, int len, ByteBuf buff) {
        LocalDateTime val = LOCAL_DATE_TIME_EPOCH.plus(buff.getLong(index), ChronoUnit.MICROS);
        if (LDT_PLUS_INFINITY.equals(val)) {
            return LocalDateTime.MAX;
        }
        if (LDT_MINUS_INFINITY.equals(val)) {
            return LocalDateTime.MIN;
        }
        return val;
    }

    private static LocalDateTime textDecodeTIMESTAMP(int index, int len, ByteBuf buff) {
        String s;
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        switch (s = cs.toString()) {
            case "infinity": {
                return LocalDateTime.MAX;
            }
            case "-infinity": {
                return LocalDateTime.MIN;
            }
        }
        return LocalDateTime.parse(cs, TIMESTAMP_FORMAT);
    }

    private static OffsetDateTime binaryDecodeTIMESTAMPTZ(int index, int len, ByteBuf buff) {
        LocalDateTime ldt = DataTypeCodec.binaryDecodeTIMESTAMP(index, len, buff);
        if (ldt == LocalDateTime.MAX) {
            return OffsetDateTime.MAX;
        }
        if (ldt == LocalDateTime.MIN) {
            return OffsetDateTime.MIN;
        }
        return OffsetDateTime.of(ldt, ZoneOffset.UTC);
    }

    private static void binaryEncodeTIMESTAMPTZ(OffsetDateTime value, ByteBuf buff) {
        OffsetDateTime min;
        OffsetDateTime max;
        LocalDateTime ldt = value.getOffset() != ZoneOffset.UTC ? (value.compareTo(max = OffsetDateTime.of(LDT_PLUS_INFINITY, ZoneOffset.UTC)) >= 0 ? LocalDateTime.MAX : (value.compareTo(min = OffsetDateTime.of(LDT_MINUS_INFINITY, ZoneOffset.UTC)) <= 0 ? LocalDateTime.MIN : value.toInstant().atOffset(ZoneOffset.UTC).toLocalDateTime())) : value.toLocalDateTime();
        DataTypeCodec.binaryEncodeTIMESTAMP(ldt, buff);
    }

    private static OffsetDateTime textDecodeTIMESTAMPTZ(int index, int len, ByteBuf buff) {
        String s;
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        switch (s = cs.toString()) {
            case "infinity": {
                return OffsetDateTime.MAX;
            }
            case "-infinity": {
                return OffsetDateTime.MIN;
            }
        }
        return OffsetDateTime.parse(cs, TIMESTAMPTZ_FORMAT);
    }

    private static Buffer textDecodeBYTEA(int index, int len, ByteBuf buff) {
        if (DataTypeCodec.isHexFormat(index, len, buff)) {
            return DataTypeCodec.decodeHexStringToBytes(index + 2, len - 2, buff);
        }
        return DataTypeCodec.decodeEscapeByteaStringToBuffer(index, len, buff);
    }

    private static void binaryEncodeBYTEA(Buffer value, ByteBuf buff) {
        ByteBuf byteBuf = value.getByteBuf();
        buff.writeBytes(byteBuf);
    }

    private static Buffer binaryDecodeBYTEA(int index, int len, ByteBuf buff) {
        ByteBuf byteBuf = VertxByteBufAllocator.DEFAULT.heapBuffer(len);
        byteBuf.writeBytes(buff, index, len);
        return Buffer.buffer((ByteBuf)byteBuf);
    }

    private static void binaryEncodeUUID(UUID uuid, ByteBuf buff) {
        buff.writeLong(uuid.getMostSignificantBits());
        buff.writeLong(uuid.getLeastSignificantBits());
    }

    private static void binaryEncodePoint(Point point, ByteBuf buff) {
        DataTypeCodec.binaryEncodeFLOAT8(point.x, buff);
        DataTypeCodec.binaryEncodeFLOAT8(point.y, buff);
    }

    private static Point binaryDecodePoint(int index, int len, ByteBuf buff) {
        double x = DataTypeCodec.binaryDecodeFLOAT8(index, 8, buff);
        double y = DataTypeCodec.binaryDecodeFLOAT8(index + 8, 8, buff);
        return new Point(x, y);
    }

    private static void binaryEncodeLine(Line line, ByteBuf buff) {
        DataTypeCodec.binaryEncodeFLOAT8(line.getA(), buff);
        DataTypeCodec.binaryEncodeFLOAT8(line.getB(), buff);
        DataTypeCodec.binaryEncodeFLOAT8(line.getC(), buff);
    }

    private static Line binaryDecodeLine(int index, int len, ByteBuf buff) {
        double a = DataTypeCodec.binaryDecodeFLOAT8(index, 8, buff);
        double b = DataTypeCodec.binaryDecodeFLOAT8(index + 8, 8, buff);
        double c = DataTypeCodec.binaryDecodeFLOAT8(index + 16, 8, buff);
        return new Line(a, b, c);
    }

    private static void binaryEncodeLseg(LineSegment lseg, ByteBuf buff) {
        DataTypeCodec.binaryEncodePoint(lseg.getP1(), buff);
        DataTypeCodec.binaryEncodePoint(lseg.getP2(), buff);
    }

    private static LineSegment binaryDecodeLseg(int index, int len, ByteBuf buff) {
        Point p1 = DataTypeCodec.binaryDecodePoint(index, 16, buff);
        Point p2 = DataTypeCodec.binaryDecodePoint(index + 16, 16, buff);
        return new LineSegment(p1, p2);
    }

    private static void binaryEncodeBox(Box box, ByteBuf buff) {
        DataTypeCodec.binaryEncodePoint(box.getUpperRightCorner(), buff);
        DataTypeCodec.binaryEncodePoint(box.getLowerLeftCorner(), buff);
    }

    private static Box binaryDecodeBox(int index, int len, ByteBuf buff) {
        Point upperRightCorner = DataTypeCodec.binaryDecodePoint(index, 16, buff);
        Point lowerLeftCorner = DataTypeCodec.binaryDecodePoint(index + 16, 16, buff);
        return new Box(upperRightCorner, lowerLeftCorner);
    }

    private static void binaryEncodePath(Path path, ByteBuf buff) {
        if (path.isOpen()) {
            buff.writeByte(0);
        } else {
            buff.writeByte(1);
        }
        List<Point> points = path.getPoints();
        DataTypeCodec.binaryEncodeINT4(points.size(), buff);
        for (Point point : points) {
            DataTypeCodec.binaryEncodePoint(point, buff);
        }
    }

    private static Path binaryDecodePath(int index, int len, ByteBuf buff) {
        boolean isOpen;
        byte first = buff.getByte(index);
        if (first == 0) {
            isOpen = true;
        } else if (first == 1) {
            isOpen = false;
        } else {
            throw new DecoderException("Decoding Path exception");
        }
        int idx = ++index;
        int numberOfPoints = DataTypeCodec.binaryDecodeINT4(idx, 4, buff);
        idx += 4;
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < numberOfPoints; ++i) {
            points.add(DataTypeCodec.binaryDecodePoint(idx, 16, buff));
            idx += 16;
        }
        return new Path(isOpen, points);
    }

    private static void binaryEncodePolygon(Polygon polygon, ByteBuf buff) {
        List<Point> points = polygon.getPoints();
        int numberOfPoints = points.size();
        DataTypeCodec.binaryEncodeINT4(numberOfPoints, buff);
        for (Point point : points) {
            DataTypeCodec.binaryEncodeFLOAT8(point.x, buff);
            DataTypeCodec.binaryEncodeFLOAT8(point.y, buff);
        }
    }

    private static Polygon binaryDecodePolygon(int index, int len, ByteBuf buff) {
        int idx = index;
        int numberOfPoints = DataTypeCodec.binaryDecodeINT4(index, 4, buff);
        idx += 4;
        ArrayList<Point> points = new ArrayList<Point>();
        for (int i = 0; i < numberOfPoints; ++i) {
            points.add(DataTypeCodec.binaryDecodePoint(idx, 16, buff));
            idx += 16;
        }
        return new Polygon(points);
    }

    private static void binaryEncodeCircle(Circle circle, ByteBuf buff) {
        DataTypeCodec.binaryEncodePoint(circle.getCenterPoint(), buff);
        DataTypeCodec.binaryEncodeFLOAT8(circle.getRadius(), buff);
    }

    private static Circle binaryDecodeCircle(int index, int len, ByteBuf buff) {
        Point center = DataTypeCodec.binaryDecodePoint(index, 16, buff);
        double radius = DataTypeCodec.binaryDecodeFLOAT8(index + 16, 8, buff);
        return new Circle(center, radius);
    }

    private static void binaryEncodeINTERVAL(Interval interval, ByteBuf buff) {
        Duration duration = Duration.ofHours(interval.getHours()).plusMinutes(interval.getMinutes()).plusSeconds(interval.getSeconds()).plus((long)interval.getMicroseconds(), ChronoUnit.MICROS);
        Period monthYear = Period.of(interval.getYears(), interval.getMonths(), interval.getDays()).normalized();
        DataTypeCodec.binaryEncodeINT8(TimeUnit.NANOSECONDS.toMicros(duration.toNanos()), buff);
        DataTypeCodec.binaryEncodeINT4(monthYear.getDays(), buff);
        DataTypeCodec.binaryEncodeINT4((int)monthYear.toTotalMonths(), buff);
    }

    private static Interval binaryDecodeINTERVAL(int index, int len, ByteBuf buff) {
        Duration duration = Duration.of(buff.getLong(index), ChronoUnit.MICROS);
        long hours = duration.toHours();
        duration = duration.minusHours(hours);
        long minutes = duration.toMinutes();
        duration = duration.minusMinutes(minutes);
        long seconds = TimeUnit.NANOSECONDS.toSeconds(duration.toNanos());
        duration = duration.minusSeconds(seconds);
        long microseconds = TimeUnit.NANOSECONDS.toMicros(duration.toNanos());
        int days = buff.getInt(index + 8);
        int months = buff.getInt(index + 12);
        Period monthYear = Period.of(0, months, days).normalized();
        return new Interval(monthYear.getYears(), monthYear.getMonths(), monthYear.getDays(), (int)hours, (int)minutes, (int)seconds, (int)microseconds);
    }

    private static UUID binaryDecodeUUID(int index, int len, ByteBuf buff) {
        return new UUID(buff.getLong(index), buff.getLong(index + 8));
    }

    private static UUID textDecodeUUID(int index, int len, ByteBuf buff) {
        return UUID.fromString(buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString());
    }

    private static Object textDecodeJSON(int index, int len, ByteBuf buff) {
        return DataTypeCodec.textDecodeJSONB(index, len, buff);
    }

    private static Object binaryDecodeJSON(int index, int len, ByteBuf buff) {
        return DataTypeCodec.textDecodeJSONB(index, len, buff);
    }

    private static void binaryEncodeJSON(Object value, ByteBuf buff) {
        String s = value == Tuple.JSON_NULL ? "null" : Json.encode((Object)value);
        buff.writeCharSequence((CharSequence)s, StandardCharsets.UTF_8);
    }

    private static Object textDecodeJSONB(int index, int len, ByteBuf buff) {
        int pos;
        CharSequence cs = buff.getCharSequence(index, len, StandardCharsets.UTF_8);
        JsonObject value = null;
        String s = cs.toString();
        for (pos = 0; pos < s.length() && Character.isWhitespace(s.charAt(pos)); ++pos) {
        }
        if (pos == s.length()) {
            return null;
        }
        if (s.charAt(pos) == '{') {
            value = new JsonObject(s);
        } else if (s.charAt(pos) == '[') {
            value = new JsonArray(s);
        } else {
            Object o = Json.decodeValue((String)s);
            if (o == null) {
                return Tuple.JSON_NULL;
            }
            if (o instanceof Number || o instanceof Boolean || o instanceof String) {
                return o;
            }
            return null;
        }
        return value;
    }

    private static Object binaryDecodeJSONB(int index, int len, ByteBuf buff) {
        return DataTypeCodec.textDecodeJSONB(index + 1, len - 1, buff);
    }

    private static void binaryEncodeJSONB(Object value, ByteBuf buff) {
        buff.writeByte(1);
        DataTypeCodec.binaryEncodeJSON(value, buff);
    }

    private static String binaryDecodeTsVector(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeTsVector(String value, ByteBuf buff) {
        buff.writeCharSequence((CharSequence)String.valueOf(value), StandardCharsets.UTF_8);
    }

    private static Inet binaryDecodeInet(int index, int len, ByteBuf buff) {
        Integer val;
        InetAddress address;
        byte family = buff.getByte(index);
        byte netmask = buff.getByte(index + 1);
        byte size = buff.getByte(index + 3);
        byte[] data = new byte[size];
        buff.getBytes(index + 4, data);
        switch (family) {
            case 2: {
                try {
                    address = Inet4Address.getByAddress(data);
                }
                catch (UnknownHostException e) {
                    throw new DecoderException((Throwable)e);
                }
                val = netmask == 32 ? null : Integer.valueOf(Byte.toUnsignedInt(netmask));
                break;
            }
            case 3: {
                try {
                    address = Inet6Address.getByAddress(data);
                }
                catch (UnknownHostException e) {
                    throw new DecoderException((Throwable)e);
                }
                val = netmask == -128 ? null : Integer.valueOf(Byte.toUnsignedInt(netmask));
                break;
            }
            default: {
                throw new DecoderException("Invalid ip family: " + family);
            }
        }
        return new Inet().setAddress(address).setNetmask(val);
    }

    private static void binaryEncodeInet(Inet value, ByteBuf buff) {
        int netmask;
        byte[] data;
        int family;
        InetAddress address = value.getAddress();
        if (address instanceof Inet6Address) {
            family = 3;
            Inet6Address inet6Address = (Inet6Address)address;
            data = inet6Address.getAddress();
            netmask = value.getNetmask() == null ? 128 : value.getNetmask();
        } else if (address instanceof Inet4Address) {
            family = 2;
            Inet4Address inet4Address = (Inet4Address)address;
            data = inet4Address.getAddress();
            netmask = value.getNetmask() == null ? 32 : value.getNetmask();
        } else {
            throw new DecoderException("Invalid inet address");
        }
        buff.writeByte(family);
        buff.writeByte(netmask);
        buff.writeByte(0);
        buff.writeByte(data.length);
        buff.writeBytes(data);
    }

    private static void binaryEncodeMoney(Money money, ByteBuf buff) {
        long integerPart = money.getIntegerPart();
        long value = integerPart >= 0L ? money.getIntegerPart() * 100L + (long)money.getDecimalPart() : money.getIntegerPart() * 100L - (long)money.getDecimalPart();
        DataTypeCodec.binaryEncodeINT8(value, buff);
    }

    private static Money binaryDecodeMoney(int index, int len, ByteBuf buff) {
        long value = DataTypeCodec.binaryDecodeINT8(index, len, buff);
        return new Money(value / 100L, Math.abs((int)value % 100));
    }

    private static String binaryDecodeTsQuery(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static void binaryEncodeTsQuery(String value, ByteBuf buff) {
        buff.writeCharSequence((CharSequence)String.valueOf(value), StandardCharsets.UTF_8);
    }

    private static String textDecodeTsVector(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static String textDecodeTsQuery(int index, int len, ByteBuf buff) {
        return buff.getCharSequence(index, len, StandardCharsets.UTF_8).toString();
    }

    private static Inet textDecodeInet(int index, int len, ByteBuf buff) {
        String s;
        Inet inet = new Inet();
        int sepIdx = buff.indexOf(index, index + len, (byte)47);
        if (sepIdx == -1) {
            s = DataTypeCodec.textdecodeTEXT(index, len, buff);
        } else {
            s = DataTypeCodec.textdecodeTEXT(index, sepIdx - index, buff);
            String t = DataTypeCodec.textdecodeTEXT(sepIdx + 1, len - (sepIdx + 1 - index), buff);
            try {
                int netmask = Integer.parseInt(t);
                inet.setNetmask(netmask);
            }
            catch (NumberFormatException e) {
                throw new DecoderException((Throwable)e);
            }
        }
        try {
            InetAddress v = InetAddress.getByName(s);
            inet.setAddress(v);
        }
        catch (UnknownHostException e) {
            throw new DecoderException((Throwable)e);
        }
        return inet;
    }

    private static Money textDecodeMoney(int index, int len, ByteBuf buff) {
        char c;
        String s = DataTypeCodec.textDecodeVARCHAR(index, len, buff);
        s = s.substring(1);
        long integerPart = 0L;
        int decimalPart = 0;
        int idx = 0;
        while (idx < s.length() && (c = s.charAt(idx++)) != '.') {
            if (c < '0' || c > '9') continue;
            integerPart = integerPart * 10L + (long)(c - 48);
        }
        while (idx < s.length()) {
            if ((c = s.charAt(idx++)) < '0' || c > '9') continue;
            decimalPart = decimalPart * 10 + (c - 48);
        }
        return new Money(integerPart, decimalPart);
    }

    private static Buffer decodeHexStringToBytes(int index, int len, ByteBuf buff) {
        Buffer buffer = Buffer.buffer((int)(len >>= 1));
        for (int i = 0; i < len; ++i) {
            byte b0 = DataTypeCodec.decodeHexChar(buff.getByte(index++));
            byte b1 = DataTypeCodec.decodeHexChar(buff.getByte(index++));
            buffer.appendByte((byte)(b0 * 16 + b1));
        }
        return buffer;
    }

    private static byte decodeHexChar(byte ch) {
        return (byte)((ch & 0x1F) + (ch >> 6) * 25 - 16 & 0xF);
    }

    private static boolean isHexFormat(int index, int len, ByteBuf buff) {
        return len >= 2 && buff.getByte(index) == 92 && buff.getByte(index + 1) == 120;
    }

    private static Buffer decodeEscapeByteaStringToBuffer(int index, int len, ByteBuf buff) {
        Buffer buffer = Buffer.buffer();
        int pos = 0;
        while (pos < len) {
            byte current = buff.getByte(pos + index);
            if (current == 92) {
                if (pos + 2 <= len && buff.getByte(pos + index + 1) == 92) {
                    buffer.appendByte((byte)92);
                    pos += 2;
                    continue;
                }
                if (pos + 4 <= len) {
                    int high = Character.digit(buff.getByte(pos + index + 1), 8) << 6;
                    int medium = Character.digit(buff.getByte(pos + index + 2), 8) << 3;
                    int low = Character.digit(buff.getByte(pos + index + 3), 8);
                    int escapedValue = high + medium + low;
                    buffer.appendByte((byte)escapedValue);
                    pos += 4;
                    continue;
                }
                throw new DecoderException("Decoding unexpected BYTEA escape format");
            }
            buffer.appendByte(current);
            ++pos;
        }
        return buffer;
    }

    private static <T> T[] binaryDecodeArray(IntFunction<T[]> supplier, DataType type, int index, int len, ByteBuf buff) {
        if (len == 12) {
            return supplier.apply(0);
        }
        int dim = buff.getInt(index);
        index += 4;
        index += 4;
        int length = buff.getInt(index += 4);
        index += 4;
        index += 4;
        if (dim != 1) {
            logger.warn((Object)"Only arrays of dimension 1 are supported");
            return null;
        }
        T[] array = supplier.apply(length);
        for (int i = 0; i < array.length; ++i) {
            int l = buff.getInt(index);
            index += 4;
            if (l == -1) continue;
            array[i] = DataTypeCodec.decodeBinary(type, index, l, buff);
            index += l;
        }
        return array;
    }

    private static <T> void binaryEncodeArray(T[] values, DataType type, ByteBuf buff) {
        int startIndex = buff.writerIndex();
        buff.writeInt(1);
        buff.writeInt(0);
        buff.writeInt(type.id);
        buff.writeInt(values.length);
        buff.writeInt(1);
        boolean hasNulls = false;
        for (T value : values) {
            if (value == null) {
                hasNulls = true;
                buff.writeInt(-1);
                continue;
            }
            int idx = buff.writerIndex();
            buff.writeInt(0);
            DataTypeCodec.encodeBinary(type, value, buff);
            buff.setInt(idx, buff.writerIndex() - idx - 4);
        }
        if (hasNulls) {
            buff.setInt(startIndex + 4, 1);
        }
    }

    private static <T> T[] textDecodeArray(IntFunction<T[]> supplier, DataType type, int index, int len, ByteBuf buff) {
        ArrayList<T> list = new ArrayList<T>();
        int from = index + 1;
        int to = index + len - 1;
        while (from < to) {
            int idx;
            boolean escaped;
            boolean bl = escaped = buff.getByte(from) == 34;
            if (escaped) {
                idx = buff.forEachByte(from, to - from, (ByteProcessor)new UTF8StringEndDetector());
                idx = buff.indexOf(idx, to, (byte)44);
            } else {
                idx = buff.indexOf(from, to, (byte)44);
            }
            if (idx == -1) {
                idx = to;
            }
            T elt = DataTypeCodec.textDecodeArrayElement(type, from, idx - from, buff);
            list.add(elt);
            from = idx + 1;
        }
        return list.toArray(supplier.apply(list.size()));
    }

    private static <T> T textDecodeArrayElement(DataType type, int index, int len, ByteBuf buff) {
        boolean escaped;
        if (len == 4 && Character.toUpperCase(buff.getByte(index)) == 78 && Character.toUpperCase(buff.getByte(index + 1)) == 85 && Character.toUpperCase(buff.getByte(index + 2)) == 76 && Character.toUpperCase(buff.getByte(index + 3)) == 76) {
            return null;
        }
        boolean bl = escaped = buff.getByte(index) == 34;
        if (escaped) {
            String s = buff.toString(index + 1, len - 2, StandardCharsets.UTF_8);
            StringBuilder sb = new StringBuilder();
            for (int i = 0; i < s.length(); ++i) {
                char c = s.charAt(i);
                if (c == '\\') {
                    c = s.charAt(++i);
                }
                sb.append(c);
            }
            buff = Unpooled.copiedBuffer((CharSequence)sb, (Charset)StandardCharsets.UTF_8);
            index = 0;
            len = buff.readableBytes();
        }
        return (T)DataTypeCodec.decodeText(type, index, len, buff);
    }

    private static <T> void textEncodeArray(T[] values, DataType type, ByteBuf buff) {
        buff.writeByte(123);
        int len = values.length;
        for (int i = 0; i < len; ++i) {
            T value;
            if (i > 0) {
                buff.writeByte(44);
            }
            if ((value = values[i]) != null) {
                DataTypeCodec.textEncode(type, value, buff);
                continue;
            }
            buff.writeByte(78);
            buff.writeByte(85);
            buff.writeByte(76);
            buff.writeByte(76);
        }
        buff.writeByte(125);
    }
}

