/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.data;

import java.math.BigDecimal;
import java.text.DecimalFormat;
import java.util.Objects;

public class Money {
    private final BigDecimal value;

    public Money(Number value) {
        this.value = (value instanceof BigDecimal ? (BigDecimal)value : new BigDecimal(String.valueOf(value))).stripTrailingZeros();
        if (this.value.toBigInteger().abs().longValue() > 92233720368547758L) {
            throw new IllegalArgumentException("Value is too big: " + value);
        }
        if (this.value.scale() > 2) {
            throw new IllegalArgumentException("Value has more than two decimal digits: " + value);
        }
    }

    public Money() {
        this.value = BigDecimal.ZERO;
    }

    public BigDecimal bigDecimalValue() {
        return this.value;
    }

    public double doubleValue() {
        return this.bigDecimalValue().doubleValue();
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        Money money = (Money)o;
        return Objects.equals(this.value, money.value);
    }

    public int hashCode() {
        return Objects.hash(this.value);
    }

    public String toString() {
        return "Money(" + new DecimalFormat("#0.##").format(this.value) + ")";
    }
}

