/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.pgclient.impl;

import io.vertx.core.buffer.Buffer;
import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import io.vertx.pgclient.data.Box;
import io.vertx.pgclient.data.Circle;
import io.vertx.pgclient.data.Interval;
import io.vertx.pgclient.data.Line;
import io.vertx.pgclient.data.LineSegment;
import io.vertx.pgclient.data.Path;
import io.vertx.pgclient.data.Point;
import io.vertx.pgclient.data.Polygon;
import io.vertx.sqlclient.Tuple;
import io.vertx.sqlclient.data.Numeric;
import io.vertx.sqlclient.impl.RowBase;
import io.vertx.sqlclient.internal.RowDesc;
import java.lang.reflect.Array;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.LocalTime;
import java.time.OffsetDateTime;
import java.time.OffsetTime;
import java.util.List;
import java.util.UUID;

public class RowImpl
extends RowBase {
    private final RowDesc desc;

    public RowImpl(RowDesc desc) {
        super(desc.columnNames().size());
        this.desc = desc;
    }

    public RowImpl(RowImpl row) {
        super((Tuple)row);
        this.desc = row.desc;
    }

    public String getColumnName(int pos) {
        List columnNames = this.desc.columnNames();
        return pos < 0 || columnNames.size() - 1 < pos ? null : (String)columnNames.get(pos);
    }

    public int getColumnIndex(String name) {
        if (name == null) {
            throw new NullPointerException();
        }
        return this.desc.columnNames().indexOf(name);
    }

    public <T> T get(Class<T> type, int position) {
        if (type.isArray()) {
            Class<?> componentType = type.getComponentType();
            if (componentType == Boolean.class) {
                return type.cast(this.getArrayOfBooleans(position));
            }
            if (componentType == Short.class) {
                return type.cast(this.getArrayOfShorts(position));
            }
            if (componentType == Integer.class) {
                return type.cast(this.getArrayOfIntegers(position));
            }
            if (componentType == Long.class) {
                return type.cast(this.getArrayOfLongs(position));
            }
            if (componentType == Float.class) {
                return type.cast(this.getArrayOfFloats(position));
            }
            if (componentType == Double.class) {
                return type.cast(this.getArrayOfDoubles(position));
            }
            if (componentType == String.class) {
                return type.cast(this.getArrayOfStrings(position));
            }
            if (componentType == Buffer.class) {
                return type.cast(this.getArrayOfBuffers(position));
            }
            if (componentType == UUID.class) {
                return type.cast(this.getArrayOfUUIDs(position));
            }
            if (componentType == LocalDate.class) {
                return type.cast(this.getArrayOfLocalDates(position));
            }
            if (componentType == LocalTime.class) {
                return type.cast(this.getArrayOfLocalTimes(position));
            }
            if (componentType == OffsetTime.class) {
                return type.cast(this.getArrayOfOffsetTimes(position));
            }
            if (componentType == LocalDateTime.class) {
                return type.cast(this.getArrayOfLocalDateTimes(position));
            }
            if (componentType == OffsetDateTime.class) {
                return type.cast(this.getArrayOfOffsetDateTimes(position));
            }
            if (componentType == Interval.class) {
                return type.cast(this.getArrayOfIntervals(position));
            }
            if (componentType == Numeric.class) {
                return type.cast(this.getArrayOfNumerics(position));
            }
            if (componentType == Point.class) {
                return type.cast(this.getArrayOfPoints(position));
            }
            if (componentType == Line.class) {
                return type.cast(this.getArrayOfLines(position));
            }
            if (componentType == LineSegment.class) {
                return type.cast(this.getArrayOfLineSegments(position));
            }
            if (componentType == Path.class) {
                return type.cast(this.getArrayOfPaths(position));
            }
            if (componentType == Polygon.class) {
                return type.cast(this.getArrayOfPolygons(position));
            }
            if (componentType == Circle.class) {
                return type.cast(this.getArrayOfCircles(position));
            }
            if (componentType == Interval.class) {
                return type.cast(this.getArrayOfIntervals(position));
            }
            if (componentType == Box.class) {
                return type.cast(this.getArrayOfBoxs(position));
            }
            if (componentType == Object.class) {
                return type.cast(this.getJsonArray_(position));
            }
            if (componentType.isEnum()) {
                return type.cast(this.getArrayOfEnums(componentType, position));
            }
        } else {
            if (type == Boolean.class) {
                return type.cast(this.getBoolean(position));
            }
            if (type == Short.class) {
                return type.cast(this.getShort(position));
            }
            if (type == Integer.class) {
                return type.cast(this.getInteger(position));
            }
            if (type == Long.class) {
                return type.cast(this.getLong(position));
            }
            if (type == Float.class) {
                return type.cast(this.getFloat(position));
            }
            if (type == Double.class) {
                return type.cast(this.getDouble(position));
            }
            if (type == Numeric.class) {
                return type.cast(this.getNumeric(position));
            }
            if (type == String.class) {
                return type.cast(this.getString(position));
            }
            if (type == Buffer.class) {
                return type.cast(this.getBuffer(position));
            }
            if (type == UUID.class) {
                return type.cast(this.getUUID(position));
            }
            if (type == LocalDate.class) {
                return type.cast(this.getLocalDate(position));
            }
            if (type == LocalTime.class) {
                return type.cast(this.getLocalTime(position));
            }
            if (type == OffsetTime.class) {
                return type.cast(this.getOffsetTime(position));
            }
            if (type == LocalDateTime.class) {
                return type.cast(this.getLocalDateTime(position));
            }
            if (type == OffsetDateTime.class) {
                return type.cast(this.getOffsetDateTime(position));
            }
            if (type == Interval.class) {
                return type.cast(this.getInterval(position));
            }
            if (type == Point.class) {
                return type.cast(this.getPoint(position));
            }
            if (type == Line.class) {
                return type.cast(this.getLine(position));
            }
            if (type == LineSegment.class) {
                return type.cast(this.getLineSegment(position));
            }
            if (type == Path.class) {
                return type.cast(this.getPath(position));
            }
            if (type == Polygon.class) {
                return type.cast(this.getPolygon(position));
            }
            if (type == Circle.class) {
                return type.cast(this.getCircle(position));
            }
            if (type == Box.class) {
                return type.cast(this.getBox(position));
            }
            if (type == JsonObject.class) {
                return type.cast(this.getJson(position));
            }
            if (type == JsonArray.class) {
                return type.cast(this.getJson(position));
            }
            if (type == Object.class) {
                return type.cast(this.getValue(position));
            }
            if (type.isEnum()) {
                return type.cast(this.getEnum(type, position));
            }
        }
        throw new UnsupportedOperationException("Unsupported type " + type.getName());
    }

    private Point getPoint(int pos) {
        return (Point)this.getValue(pos);
    }

    private Line getLine(int pos) {
        return (Line)this.getValue(pos);
    }

    private LineSegment getLineSegment(int pos) {
        return (LineSegment)this.getValue(pos);
    }

    private Box getBox(int pos) {
        return (Box)this.getValue(pos);
    }

    private Path getPath(int pos) {
        return (Path)this.getValue(pos);
    }

    private Polygon getPolygon(int pos) {
        return (Polygon)this.getValue(pos);
    }

    private Circle getCircle(int pos) {
        return (Circle)this.getValue(pos);
    }

    private Interval getInterval(int pos) {
        return (Interval)this.getValue(pos);
    }

    private Object getEnum(Class enumType, int pos) {
        Object val = this.getValue(pos);
        if (val instanceof String) {
            return Enum.valueOf(enumType, (String)val);
        }
        if (val instanceof Number) {
            T[] constants;
            int ordinal = ((Number)val).intValue();
            if (ordinal >= 0 && ordinal < (constants = enumType.getEnumConstants()).length) {
                return constants[ordinal];
            }
        } else if (val == null) {
            return null;
        }
        throw new ClassCastException();
    }

    private Object[] getJsonArray_(int pos) {
        return (Object[])this.getValue(pos);
    }

    private Point[] getArrayOfPoints(int pos) {
        return (Point[])this.getValue(pos);
    }

    private Line[] getArrayOfLines(int pos) {
        return (Line[])this.getValue(pos);
    }

    private LineSegment[] getArrayOfLineSegments(int pos) {
        return (LineSegment[])this.getValue(pos);
    }

    private Box[] getArrayOfBoxs(int pos) {
        return (Box[])this.getValue(pos);
    }

    private Path[] getArrayOfPaths(int pos) {
        return (Path[])this.getValue(pos);
    }

    private Polygon[] getArrayOfPolygons(int pos) {
        return (Polygon[])this.getValue(pos);
    }

    private Circle[] getArrayOfCircles(int pos) {
        return (Circle[])this.getValue(pos);
    }

    private Interval[] getArrayOfIntervals(int pos) {
        return (Interval[])this.getValue(pos);
    }

    private Object[] getArrayOfEnums(Class enumType, int pos) {
        Object val = this.getValue(pos);
        if (val == null) {
            return null;
        }
        if (val instanceof String[]) {
            String[] array = (String[])val;
            Object[] ret = (Object[])Array.newInstance(enumType, array.length);
            for (int i = 0; i < array.length; ++i) {
                String string = array[i];
                if (string == null) continue;
                ret[i] = Enum.valueOf(enumType, string);
            }
            return ret;
        }
        if (val instanceof Number[]) {
            Number[] array = (Number[])val;
            Object[] ret = (Object[])Array.newInstance(enumType, array.length);
            T[] constants = enumType.getEnumConstants();
            for (int i = 0; i < array.length; ++i) {
                Number number = array[i];
                int ordinal = number.intValue();
                if (ordinal < 0 || ordinal >= constants.length) continue;
                ret[i] = constants[ordinal];
            }
            return ret;
        }
        throw new ClassCastException();
    }
}

