/*
 * Decompiled with CFR 0.152.
 */
package io.vertx.proton.impl;

import io.vertx.core.logging.Logger;
import io.vertx.core.logging.LoggerFactory;
import java.io.BufferedReader;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.nio.charset.StandardCharsets;
import org.apache.qpid.proton.amqp.Symbol;

public class ProtonMetaDataSupportImpl {
    private static final Logger LOG;
    public static final String PRODUCT = "vertx-proton";
    public static final Symbol PRODUCT_KEY;
    public static final String VERSION;
    public static final Symbol VERSION_KEY;

    static {
        String version;
        block15: {
            LOG = LoggerFactory.getLogger(ProtonMetaDataSupportImpl.class);
            PRODUCT_KEY = Symbol.valueOf((String)"product");
            VERSION_KEY = Symbol.valueOf((String)"version");
            version = "unknown";
            try {
                InputStream in = null;
                String path = ProtonMetaDataSupportImpl.class.getPackage().getName().replace(".", "/");
                in = ProtonMetaDataSupportImpl.class.getResourceAsStream("/" + path + "/version.txt");
                if (in == null) break block15;
                try (BufferedReader reader = new BufferedReader(new InputStreamReader(in, StandardCharsets.UTF_8));){
                    String line = reader.readLine();
                    if (line != null && !line.isEmpty()) {
                        version = line;
                    }
                }
            }
            catch (Throwable err) {
                LOG.error((Object)"Problem determining version details", err);
            }
        }
        VERSION = version;
    }
}

